/*
 * Decompiled with CFR 0.152.
 */
package util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry<V>[] table = new Entry[16];
    private transient int size;
    private int threshold = 12;
    private final float loadFactor;
    private volatile transient int modCount;

    public LongHashMap() {
        this.loadFactor = 0.75f;
    }

    private static int hash(long l) {
        return LongHashMap.hash((int)(l ^ l >>> 32));
    }

    private static int hash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(long l) {
        int n = LongHashMap.hash(l);
        Entry<V> entry = this.table[LongHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(long l) {
        return this.getEntry(l) != null;
    }

    final Entry<V> getEntry(long l) {
        int n = LongHashMap.hash(l);
        Entry<V> entry = this.table[LongHashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            if (entry.key == l) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public void put(long l, V v) {
        int n = LongHashMap.hash(l);
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<V> entry = this.table[n2];
        while (entry != null) {
            if (entry.key == l) {
                entry.value = v;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, l, v, n2);
    }

    private void resize(int n) {
        Entry<V>[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    private void transfer(Entry<V>[] entryArray) {
        Entry<V>[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry<V> entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = LongHashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    public V remove(long l) {
        Entry<V> entry = this.removeEntryForKey(l);
        return entry == null ? null : (V)entry.value;
    }

    final Entry<V> removeEntryForKey(long l) {
        Entry<V> entry;
        int n = LongHashMap.hash(l);
        int n2 = LongHashMap.indexFor(n, this.table.length);
        Entry<V> entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == l) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    public void clear() {
        ++this.modCount;
        Entry<V>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<V>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<V> entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<V>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<V> entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private void addEntry(int n, long l, V v, int n2) {
        Entry<V> entry = this.table[n2];
        this.table[n2] = new Entry<V>(n, l, v, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        final long key;
        V value;
        Entry<V> next;
        final int hash;

        Entry(int n, long l, V v, Entry<V> entry) {
            this.value = v;
            this.next = entry;
            this.key = l;
            this.hash = n;
        }

        public final long getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        public final boolean equals(Object object) {
            V v;
            V v2;
            Long l;
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            Long l2 = this.getKey();
            return (l2 == (l = Long.valueOf(entry.getKey())) || l2 != null && ((Object)l2).equals(l)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        public final int hashCode() {
            return LongHashMap.hash(this.key);
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

