/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.ArrayList;
import java.util.List;
import util.Mth;

public class Vec3 {
    private static List<Vec3> pool = new ArrayList<Vec3>();
    private static int poolPointer = 0;
    public double x;
    public double y;
    public double z;

    public static Vec3 newPermanent(double d, double d2, double d3) {
        return new Vec3(d, d2, d3);
    }

    public static void resetPool() {
        poolPointer = 0;
    }

    public static Vec3 newTemp(double d, double d2, double d3) {
        if (poolPointer >= pool.size()) {
            pool.add(Vec3.newPermanent(0.0, 0.0, 0.0));
        }
        return pool.get(poolPointer++).set(d, d2, d3);
    }

    private Vec3(double d, double d2, double d3) {
        if (d == -0.0) {
            d = 0.0;
        }
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        if (d3 == -0.0) {
            d3 = 0.0;
        }
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    private Vec3 set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vec3 interpolateTo(Vec3 vec3, double d) {
        double d2 = this.x + (vec3.x - this.x) * d;
        double d3 = this.y + (vec3.y - this.y) * d;
        double d4 = this.z + (vec3.z - this.z) * d;
        return Vec3.newTemp(d2, d3, d4);
    }

    public Vec3 vectorTo(Vec3 vec3) {
        return Vec3.newTemp(vec3.x - this.x, vec3.y - this.y, vec3.z - this.z);
    }

    public Vec3 normalize() {
        double d = Mth.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d < 1.0E-4) {
            return Vec3.newTemp(0.0, 0.0, 0.0);
        }
        return Vec3.newTemp(this.x / d, this.y / d, this.z / d);
    }

    public double dot(Vec3 vec3) {
        return this.x * vec3.x + this.y * vec3.y + this.z * vec3.z;
    }

    public Vec3 cross(Vec3 vec3) {
        return Vec3.newTemp(this.y * vec3.z - this.z * vec3.y, this.z * vec3.x - this.x * vec3.z, this.x * vec3.y - this.y * vec3.x);
    }

    public Vec3 add(double d, double d2, double d3) {
        return Vec3.newTemp(this.x + d, this.y + d2, this.z + d3);
    }

    public double distanceTo(Vec3 vec3) {
        double d = vec3.x - this.x;
        double d2 = vec3.y - this.y;
        double d3 = vec3.z - this.z;
        return Mth.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double distanceToSqr(Vec3 vec3) {
        double d = vec3.x - this.x;
        double d2 = vec3.y - this.y;
        double d3 = vec3.z - this.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public double distanceToSqr(double d, double d2, double d3) {
        double d4 = d - this.x;
        double d5 = d2 - this.y;
        double d6 = d3 - this.z;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public Vec3 scale(double d) {
        return Vec3.newTemp(this.x * d, this.y * d, this.z * d);
    }

    public double length() {
        return Mth.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec3 clipX(Vec3 vec3, double d) {
        double d2 = vec3.x - this.x;
        double d3 = vec3.y - this.y;
        double d4 = vec3.z - this.z;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d5 = (d - this.x) / d2;
        if (d5 < 0.0 || d5 > 1.0) {
            return null;
        }
        return Vec3.newTemp(this.x + d2 * d5, this.y + d3 * d5, this.z + d4 * d5);
    }

    public Vec3 clipY(Vec3 vec3, double d) {
        double d2 = vec3.x - this.x;
        double d3 = vec3.y - this.y;
        double d4 = vec3.z - this.z;
        if (d3 * d3 < (double)1.0E-7f) {
            return null;
        }
        double d5 = (d - this.y) / d3;
        if (d5 < 0.0 || d5 > 1.0) {
            return null;
        }
        return Vec3.newTemp(this.x + d2 * d5, this.y + d3 * d5, this.z + d4 * d5);
    }

    public Vec3 clipZ(Vec3 vec3, double d) {
        double d2 = vec3.x - this.x;
        double d3 = vec3.y - this.y;
        double d4 = vec3.z - this.z;
        if (d4 * d4 < (double)1.0E-7f) {
            return null;
        }
        double d5 = (d - this.z) / d4;
        if (d5 < 0.0 || d5 > 1.0) {
            return null;
        }
        return Vec3.newTemp(this.x + d2 * d5, this.y + d3 * d5, this.z + d4 * d5);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Vec3 lerp(Vec3 vec3, double d) {
        return Vec3.newTemp(this.x + (vec3.x - this.x) * d, this.y + (vec3.y - this.y) * d, this.z + (vec3.z - this.z) * d);
    }

    public void xRot(float f) {
        float f2 = Mth.cos(f);
        float f3 = Mth.sin(f);
        double d = this.x;
        double d2 = this.y * (double)f2 + this.z * (double)f3;
        double d3 = this.z * (double)f2 - this.y * (double)f3;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void yRot(float f) {
        float f2 = Mth.cos(f);
        float f3 = Mth.sin(f);
        double d = this.x * (double)f2 + this.z * (double)f3;
        double d2 = this.y;
        double d3 = this.z * (double)f2 - this.x * (double)f3;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void zRot(float f) {
        float f2 = Mth.cos(f);
        float f3 = Mth.sin(f);
        double d = this.x * (double)f2 + this.y * (double)f3;
        double d2 = this.y * (double)f2 - this.x * (double)f3;
        double d3 = this.z;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }
}

