/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class HitResult {
    public Type type;
    public int x;
    public int y;
    public int z;
    public int f;
    public Vec3 pos;
    public Entity entity;

    public HitResult(int n, int n2, int n3, int n4, Vec3 vec3) {
        this.type = Type.TILE;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.f = n4;
        this.pos = Vec3.newTemp(vec3.x, vec3.y, vec3.z);
    }

    public HitResult(Entity entity) {
        this.type = Type.ENTITY;
        this.entity = entity;
        this.pos = Vec3.newTemp(entity.x, entity.y, entity.z);
    }

    public double distanceTo(Entity entity) {
        double d = this.pos.x - entity.x;
        double d2 = this.pos.y - entity.y;
        double d3 = this.pos.z - entity.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TILE,
        ENTITY;

    }
}

