/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AABB {
    private static List<AABB> pool = new ArrayList<AABB>();
    private static int poolPointer = 0;
    public double x0;
    public double y0;
    public double z0;
    public double x1;
    public double y1;
    public double z1;

    public static AABB newPermanent(double d, double d2, double d3, double d4, double d5, double d6) {
        return new AABB(d, d2, d3, d4, d5, d6);
    }

    public static void resetPool() {
        poolPointer = 0;
    }

    public static AABB newTemp(double d, double d2, double d3, double d4, double d5, double d6) {
        if (poolPointer >= pool.size()) {
            pool.add(AABB.newPermanent(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return pool.get(poolPointer++).set(d, d2, d3, d4, d5, d6);
    }

    private AABB(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x0 = d;
        this.y0 = d2;
        this.z0 = d3;
        this.x1 = d4;
        this.y1 = d5;
        this.z1 = d6;
    }

    public AABB set(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x0 = d;
        this.y0 = d2;
        this.z0 = d3;
        this.x1 = d4;
        this.y1 = d5;
        this.z1 = d6;
        return this;
    }

    public AABB expand(double d, double d2, double d3) {
        double d4 = this.x0;
        double d5 = this.y0;
        double d6 = this.z0;
        double d7 = this.x1;
        double d8 = this.y1;
        double d9 = this.z1;
        if (d < 0.0) {
            d4 += d;
        }
        if (d > 0.0) {
            d7 += d;
        }
        if (d2 < 0.0) {
            d5 += d2;
        }
        if (d2 > 0.0) {
            d8 += d2;
        }
        if (d3 < 0.0) {
            d6 += d3;
        }
        if (d3 > 0.0) {
            d9 += d3;
        }
        return AABB.newTemp(d4, d5, d6, d7, d8, d9);
    }

    public AABB grow(double d, double d2, double d3) {
        double d4 = this.x0 - d;
        double d5 = this.y0 - d2;
        double d6 = this.z0 - d3;
        double d7 = this.x1 + d;
        double d8 = this.y1 + d2;
        double d9 = this.z1 + d3;
        return AABB.newTemp(d4, d5, d6, d7, d8, d9);
    }

    public AABB cloneMove(double d, double d2, double d3) {
        return AABB.newTemp(this.x0 + d, this.y0 + d2, this.z0 + d3, this.x1 + d, this.y1 + d2, this.z1 + d3);
    }

    public double clipXCollide(AABB aABB, double d) {
        double d2;
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return d;
        }
        if (aABB.z1 <= this.z0 || aABB.z0 >= this.z1) {
            return d;
        }
        if (d > 0.0 && aABB.x1 <= this.x0 && (d2 = this.x0 - aABB.x1) < d) {
            d = d2;
        }
        if (d < 0.0 && aABB.x0 >= this.x1 && (d2 = this.x1 - aABB.x0) > d) {
            d = d2;
        }
        return d;
    }

    public double clipYCollide(AABB aABB, double d) {
        double d2;
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return d;
        }
        if (aABB.z1 <= this.z0 || aABB.z0 >= this.z1) {
            return d;
        }
        if (d > 0.0 && aABB.y1 <= this.y0 && (d2 = this.y0 - aABB.y1) < d) {
            d = d2;
        }
        if (d < 0.0 && aABB.y0 >= this.y1 && (d2 = this.y1 - aABB.y0) > d) {
            d = d2;
        }
        return d;
    }

    public double clipZCollide(AABB aABB, double d) {
        double d2;
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return d;
        }
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return d;
        }
        if (d > 0.0 && aABB.z1 <= this.z0 && (d2 = this.z0 - aABB.z1) < d) {
            d = d2;
        }
        if (d < 0.0 && aABB.z0 >= this.z1 && (d2 = this.z1 - aABB.z0) > d) {
            d = d2;
        }
        return d;
    }

    public boolean intersects(AABB aABB) {
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return false;
        }
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return false;
        }
        return !(aABB.z1 <= this.z0) && !(aABB.z0 >= this.z1);
    }

    public boolean intersectsInner(AABB aABB) {
        if (aABB.x1 < this.x0 || aABB.x0 > this.x1) {
            return false;
        }
        if (aABB.y1 < this.y0 || aABB.y0 > this.y1) {
            return false;
        }
        return !(aABB.z1 < this.z0) && !(aABB.z0 > this.z1);
    }

    public AABB move(double d, double d2, double d3) {
        this.x0 += d;
        this.y0 += d2;
        this.z0 += d3;
        this.x1 += d;
        this.y1 += d2;
        this.z1 += d3;
        return this;
    }

    public boolean intersects(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d4 <= this.x0 || d >= this.x1) {
            return false;
        }
        if (d5 <= this.y0 || d2 >= this.y1) {
            return false;
        }
        return !(d6 <= this.z0) && !(d3 >= this.z1);
    }

    public boolean contains(Vec3 vec3) {
        if (vec3.x <= this.x0 || vec3.x >= this.x1) {
            return false;
        }
        if (vec3.y <= this.y0 || vec3.y >= this.y1) {
            return false;
        }
        return !(vec3.z <= this.z0) && !(vec3.z >= this.z1);
    }

    public double getSize() {
        double d = this.x1 - this.x0;
        double d2 = this.y1 - this.y0;
        double d3 = this.z1 - this.z0;
        return (d + d2 + d3) / 3.0;
    }

    public AABB shrink(double d, double d2, double d3) {
        double d4 = this.x0;
        double d5 = this.y0;
        double d6 = this.z0;
        double d7 = this.x1;
        double d8 = this.y1;
        double d9 = this.z1;
        if (d < 0.0) {
            d4 -= d;
        }
        if (d > 0.0) {
            d7 -= d;
        }
        if (d2 < 0.0) {
            d5 -= d2;
        }
        if (d2 > 0.0) {
            d8 -= d2;
        }
        if (d3 < 0.0) {
            d6 -= d3;
        }
        if (d3 > 0.0) {
            d9 -= d3;
        }
        return AABB.newTemp(d4, d5, d6, d7, d8, d9);
    }

    public AABB copy() {
        return AABB.newTemp(this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
    }

    public HitResult clip(Vec3 vec3, Vec3 vec32) {
        Vec3 vec33 = vec3.clipX(vec32, this.x0);
        Vec3 vec34 = vec3.clipX(vec32, this.x1);
        Vec3 vec35 = vec3.clipY(vec32, this.y0);
        Vec3 vec36 = vec3.clipY(vec32, this.y1);
        Vec3 vec37 = vec3.clipZ(vec32, this.z0);
        Vec3 vec38 = vec3.clipZ(vec32, this.z1);
        if (!this.containsX(vec33)) {
            vec33 = null;
        }
        if (!this.containsX(vec34)) {
            vec34 = null;
        }
        if (!this.containsY(vec35)) {
            vec35 = null;
        }
        if (!this.containsY(vec36)) {
            vec36 = null;
        }
        if (!this.containsZ(vec37)) {
            vec37 = null;
        }
        if (!this.containsZ(vec38)) {
            vec38 = null;
        }
        Vec3 vec39 = null;
        if (vec33 != null && (vec39 == null || vec3.distanceToSqr(vec33) < vec3.distanceToSqr(vec39))) {
            vec39 = vec33;
        }
        if (vec34 != null && (vec39 == null || vec3.distanceToSqr(vec34) < vec3.distanceToSqr(vec39))) {
            vec39 = vec34;
        }
        if (vec35 != null && (vec39 == null || vec3.distanceToSqr(vec35) < vec3.distanceToSqr(vec39))) {
            vec39 = vec35;
        }
        if (vec36 != null && (vec39 == null || vec3.distanceToSqr(vec36) < vec3.distanceToSqr(vec39))) {
            vec39 = vec36;
        }
        if (vec37 != null && (vec39 == null || vec3.distanceToSqr(vec37) < vec3.distanceToSqr(vec39))) {
            vec39 = vec37;
        }
        if (vec38 != null && (vec39 == null || vec3.distanceToSqr(vec38) < vec3.distanceToSqr(vec39))) {
            vec39 = vec38;
        }
        if (vec39 == null) {
            return null;
        }
        int n = -1;
        if (vec39 == vec33) {
            n = 4;
        }
        if (vec39 == vec34) {
            n = 5;
        }
        if (vec39 == vec35) {
            n = 0;
        }
        if (vec39 == vec36) {
            n = 1;
        }
        if (vec39 == vec37) {
            n = 2;
        }
        if (vec39 == vec38) {
            n = 3;
        }
        return new HitResult(0, 0, 0, n, vec39);
    }

    private boolean containsX(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.y >= this.y0 && vec3.y <= this.y1 && vec3.z >= this.z0 && vec3.z <= this.z1;
    }

    private boolean containsY(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x >= this.x0 && vec3.x <= this.x1 && vec3.z >= this.z0 && vec3.z <= this.z1;
    }

    private boolean containsZ(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x >= this.x0 && vec3.x <= this.x1 && vec3.y >= this.y0 && vec3.y <= this.y1;
    }

    public void set(AABB aABB) {
        this.x0 = aABB.x0;
        this.y0 = aABB.y0;
        this.z0 = aABB.z0;
        this.x1 = aABB.x1;
        this.y1 = aABB.y1;
        this.z1 = aABB.z1;
    }

    public String toString() {
        return "box[" + this.x0 + ", " + this.y0 + ", " + this.z0 + " -> " + this.x1 + ", " + this.y1 + ", " + this.z1 + "]";
    }
}

