/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile.entity;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.ChestTileEntity;
import net.minecraft.world.level.tile.entity.DispenserTileEntity;
import net.minecraft.world.level.tile.entity.FurnaceTileEntity;
import net.minecraft.world.level.tile.entity.MobSpawnerTileEntity;
import net.minecraft.world.level.tile.entity.MusicTileEntity;
import net.minecraft.world.level.tile.entity.SignTileEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileEntity {
    private static Map<String, Class<? extends TileEntity>> idClassMap = new HashMap<String, Class<? extends TileEntity>>();
    private static Map<Class<? extends TileEntity>, String> classIdMap = new HashMap<Class<? extends TileEntity>, String>();
    public Level level;
    public int x;
    public int y;
    public int z;

    private static void setId(Class<? extends TileEntity> clazz, String string) {
        if (classIdMap.containsKey(string)) {
            throw new IllegalArgumentException("Duplicate id: " + string);
        }
        idClassMap.put(string, clazz);
        classIdMap.put(clazz, string);
    }

    public void load(CompoundTag compoundTag) {
        this.x = compoundTag.getInt("x");
        this.y = compoundTag.getInt("y");
        this.z = compoundTag.getInt("z");
    }

    public void save(CompoundTag compoundTag) {
        String string = classIdMap.get(this.getClass());
        if (string == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compoundTag.putString("id", string);
        compoundTag.putInt("x", this.x);
        compoundTag.putInt("y", this.y);
        compoundTag.putInt("z", this.z);
    }

    public void tick() {
    }

    public static TileEntity loadStatic(CompoundTag compoundTag) {
        TileEntity tileEntity = null;
        try {
            Class<? extends TileEntity> clazz = idClassMap.get(compoundTag.getString("id"));
            if (clazz != null) {
                tileEntity = clazz.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tileEntity != null) {
            tileEntity.load(compoundTag);
        } else {
            System.out.println("Skipping TileEntity with id " + compoundTag.getString("id"));
        }
        return tileEntity;
    }

    public int getData() {
        return this.level.getData(this.x, this.y, this.z);
    }

    public void setData(int n) {
        this.level.setData(this.x, this.y, this.z, n);
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.tileEntityChanged(this.x, this.y, this.z, this);
        }
    }

    public double distanceToSqr(double d, double d2, double d3) {
        double d4 = (double)this.x + 0.5 - d;
        double d5 = (double)this.y + 0.5 - d2;
        double d6 = (double)this.z + 0.5 - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public Tile getTile() {
        return Tile.tiles[this.level.getTile(this.x, this.y, this.z)];
    }

    public Packet getUpdatePacket() {
        return null;
    }

    static {
        TileEntity.setId(FurnaceTileEntity.class, "Furnace");
        TileEntity.setId(ChestTileEntity.class, "Chest");
        TileEntity.setId(DispenserTileEntity.class, "Trap");
        TileEntity.setId(SignTileEntity.class, "Sign");
        TileEntity.setId(MobSpawnerTileEntity.class, "MobSpawner");
        TileEntity.setId(MusicTileEntity.class, "Music");
    }
}

