/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.entity.TileEntity;

public class MusicTileEntity
extends TileEntity {
    public byte note = 0;
    public boolean on = false;

    public void save(CompoundTag compoundTag) {
        super.save(compoundTag);
        compoundTag.putByte("note", this.note);
    }

    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        this.note = compoundTag.getByte("note");
        if (this.note < 0) {
            this.note = 0;
        }
        if (this.note > 24) {
            this.note = (byte)24;
        }
    }

    public void tune() {
        this.note = (byte)((this.note + 1) % 25);
        this.setChanged();
    }

    public void playNote(Level level, int n, int n2, int n3) {
        if (level.getMaterial(n, n2 + 1, n3) != Material.air) {
            return;
        }
        Material material = level.getMaterial(n, n2 - 1, n3);
        int n4 = 0;
        if (material == Material.stone) {
            n4 = 1;
        }
        if (material == Material.sand) {
            n4 = 2;
        }
        if (material == Material.glass) {
            n4 = 3;
        }
        if (material == Material.wood) {
            n4 = 4;
        }
        level.tileEvent(n, n2, n3, n4, this.note);
    }
}

