/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.world.entity.EntityIO;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;

public class MobSpawnerTileEntity
extends TileEntity {
    private static final int MAX_DIST = 16;
    public int spawnDelay = 20;
    private String entityId = "Pig";
    public double spin;
    public double oSpin = 0.0;

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String string) {
        this.entityId = string;
    }

    public boolean isNearPlayer() {
        return this.level.getNearestPlayer((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, 16.0) != null;
    }

    public void tick() {
        this.oSpin = this.spin;
        if (!this.isNearPlayer()) {
            return;
        }
        double d = (float)this.x + this.level.random.nextFloat();
        double d2 = (float)this.y + this.level.random.nextFloat();
        double d3 = (float)this.z + this.level.random.nextFloat();
        this.level.addParticle("smoke", d, d2, d3, 0.0, 0.0, 0.0);
        this.level.addParticle("flame", d, d2, d3, 0.0, 0.0, 0.0);
        this.spin += (double)(1000.0f / ((float)this.spawnDelay + 200.0f));
        while (this.spin > 360.0) {
            this.spin -= 360.0;
            this.oSpin -= 360.0;
        }
        if (this.spawnDelay == -1) {
            this.delay();
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        int n = 4;
        for (int i = 0; i < n; ++i) {
            Mob mob = (Mob)EntityIO.newEntity(this.entityId, this.level);
            if (mob == null) {
                return;
            }
            int n2 = this.level.getEntitiesOfClass(mob.getClass(), AABB.newTemp(this.x, this.y, this.z, this.x + 1, this.y + 1, this.z + 1).grow(8.0, 4.0, 8.0)).size();
            if (n2 >= 6) {
                this.delay();
                return;
            }
            if (mob == null) continue;
            double d4 = (double)this.x + (this.level.random.nextDouble() - this.level.random.nextDouble()) * 4.0;
            double d5 = this.y + this.level.random.nextInt(3) - 1;
            double d6 = (double)this.z + (this.level.random.nextDouble() - this.level.random.nextDouble()) * 4.0;
            mob.moveTo(d4, d5, d6, this.level.random.nextFloat() * 360.0f, 0.0f);
            if (!mob.canSpawn()) continue;
            this.level.addEntity(mob);
            for (int j = 0; j < 20; ++j) {
                d = (double)this.x + 0.5 + ((double)this.level.random.nextFloat() - 0.5) * 2.0;
                d2 = (double)this.y + 0.5 + ((double)this.level.random.nextFloat() - 0.5) * 2.0;
                d3 = (double)this.z + 0.5 + ((double)this.level.random.nextFloat() - 0.5) * 2.0;
                this.level.addParticle("smoke", d, d2, d3, 0.0, 0.0, 0.0);
                this.level.addParticle("flame", d, d2, d3, 0.0, 0.0, 0.0);
            }
            mob.spawnAnim();
            this.delay();
        }
        super.tick();
    }

    private void delay() {
        this.spawnDelay = 200 + this.level.random.nextInt(600);
    }

    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        this.entityId = compoundTag.getString("EntityId");
        this.spawnDelay = compoundTag.getShort("Delay");
    }

    public void save(CompoundTag compoundTag) {
        super.save(compoundTag);
        compoundTag.putString("EntityId", this.entityId);
        compoundTag.putShort("Delay", (short)this.spawnDelay);
    }
}

