/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.crafting.FurnaceRecipes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.FurnaceTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.TileEntity;

public class FurnaceTileEntity
extends TileEntity
implements Container {
    private static final int BURN_INTERVAL = 200;
    private ItemInstance[] items = new ItemInstance[3];
    public int litTime = 0;
    public int litDuration = 0;
    public int tickCount = 0;

    public int getContainerSize() {
        return this.items.length;
    }

    public ItemInstance getItem(int n) {
        return this.items[n];
    }

    public ItemInstance removeItem(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemInstance itemInstance = this.items[n];
                this.items[n] = null;
                return itemInstance;
            }
            ItemInstance itemInstance = this.items[n].remove(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemInstance;
        }
        return null;
    }

    public void setItem(int n, ItemInstance itemInstance) {
        this.items[n] = itemInstance;
        if (itemInstance != null && itemInstance.count > this.getMaxStackSize()) {
            itemInstance.count = this.getMaxStackSize();
        }
    }

    public String getName() {
        return "Furnace";
    }

    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        ListTag<? extends Tag> listTag = compoundTag.getList("Items");
        this.items = new ItemInstance[this.getContainerSize()];
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag2 = (CompoundTag)listTag.get(i);
            byte by = compoundTag2.getByte("Slot");
            if (by < 0 || by >= this.items.length) continue;
            this.items[by] = new ItemInstance(compoundTag2);
        }
        this.litTime = compoundTag.getShort("BurnTime");
        this.tickCount = compoundTag.getShort("CookTime");
        this.litDuration = this.getBurnDuration(this.items[1]);
    }

    public void save(CompoundTag compoundTag) {
        super.save(compoundTag);
        compoundTag.putShort("BurnTime", (short)this.litTime);
        compoundTag.putShort("CookTime", (short)this.tickCount);
        ListTag<CompoundTag> listTag = new ListTag<CompoundTag>();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            CompoundTag compoundTag2 = new CompoundTag();
            compoundTag2.putByte("Slot", (byte)i);
            this.items[i].save(compoundTag2);
            listTag.add(compoundTag2);
        }
        compoundTag.put("Items", listTag);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public int getBurnProgress(int n) {
        return this.tickCount * n / 200;
    }

    public int getLitProgress(int n) {
        if (this.litDuration == 0) {
            this.litDuration = 200;
        }
        return this.litTime * n / this.litDuration;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    public void tick() {
        boolean bl = this.litTime > 0;
        boolean bl2 = false;
        if (this.litTime > 0) {
            --this.litTime;
        }
        if (!this.level.isOnline) {
            if (this.litTime == 0 && this.canBurn()) {
                this.litDuration = this.litTime = this.getBurnDuration(this.items[1]);
                if (this.litTime > 0) {
                    bl2 = true;
                    if (this.items[1] != null) {
                        --this.items[1].count;
                        if (this.items[1].count == 0) {
                            this.items[1] = null;
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn()) {
                ++this.tickCount;
                if (this.tickCount == 200) {
                    this.tickCount = 0;
                    this.burn();
                    bl2 = true;
                }
            } else {
                this.tickCount = 0;
            }
            if (bl != this.litTime > 0) {
                bl2 = true;
                FurnaceTile.setLit(this.litTime > 0, this.level, this.x, this.y, this.z);
            }
        }
        if (bl2) {
            this.setChanged();
        }
    }

    private boolean canBurn() {
        if (this.items[0] == null) {
            return false;
        }
        ItemInstance itemInstance = FurnaceRecipes.getInstance().getResult(this.items[0].getItem().id);
        if (itemInstance == null) {
            return false;
        }
        if (this.items[2] == null) {
            return true;
        }
        if (!this.items[2].sameItem(itemInstance)) {
            return false;
        }
        if (this.items[2].count < this.getMaxStackSize() && this.items[2].count < this.items[2].getMaxStackSize()) {
            return true;
        }
        return this.items[2].count < itemInstance.getMaxStackSize();
    }

    public void burn() {
        if (!this.canBurn()) {
            return;
        }
        ItemInstance itemInstance = FurnaceRecipes.getInstance().getResult(this.items[0].getItem().id);
        if (this.items[2] == null) {
            this.items[2] = itemInstance.copy();
        } else if (this.items[2].id == itemInstance.id) {
            ++this.items[2].count;
        }
        --this.items[0].count;
        if (this.items[0].count <= 0) {
            this.items[0] = null;
        }
    }

    private int getBurnDuration(ItemInstance itemInstance) {
        if (itemInstance == null) {
            return 0;
        }
        int n = itemInstance.getItem().id;
        if (n < 256 && Tile.tiles[n].material == Material.wood) {
            return 300;
        }
        if (n == Item.stick.id) {
            return 100;
        }
        if (n == Item.coal.id) {
            return 1600;
        }
        if (n == Item.bucket_lava.id) {
            return 20000;
        }
        return 0;
    }

    public boolean stillValid(Player player) {
        if (this.level.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > 64.0);
    }
}

