/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.tile.entity.TileEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChestTileEntity
extends TileEntity
implements Container {
    private ItemInstance[] items = new ItemInstance[36];

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    public ItemInstance getItem(int n) {
        return this.items[n];
    }

    @Override
    public ItemInstance removeItem(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemInstance itemInstance = this.items[n];
                this.items[n] = null;
                this.setChanged();
                return itemInstance;
            }
            ItemInstance itemInstance = this.items[n].remove(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            this.setChanged();
            return itemInstance;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemInstance itemInstance) {
        this.items[n] = itemInstance;
        if (itemInstance != null && itemInstance.count > this.getMaxStackSize()) {
            itemInstance.count = this.getMaxStackSize();
        }
        this.setChanged();
    }

    @Override
    public String getName() {
        return "Chest";
    }

    @Override
    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        ListTag<? extends Tag> listTag = compoundTag.getList("Items");
        this.items = new ItemInstance[this.getContainerSize()];
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag2 = (CompoundTag)listTag.get(i);
            int n = compoundTag2.getByte("Slot") & 0xFF;
            if (n < 0 || n >= this.items.length) continue;
            this.items[n] = new ItemInstance(compoundTag2);
        }
    }

    @Override
    public void save(CompoundTag compoundTag) {
        super.save(compoundTag);
        ListTag<CompoundTag> listTag = new ListTag<CompoundTag>();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            CompoundTag compoundTag2 = new CompoundTag();
            compoundTag2.putByte("Slot", (byte)i);
            this.items[i].save(compoundTag2);
            listTag.add(compoundTag2);
        }
        compoundTag.put("Items", listTag);
    }

    public void load(ListTag<CompoundTag> listTag) {
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.level.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > 64.0);
    }
}

