/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class TreeTile
extends Tile {
    public static final int DARK_TRUNK = 1;
    public static final int BIRCH_TRUNK = 2;

    protected TreeTile(int n) {
        super(n, Material.wood);
        this.tex = 20;
    }

    public int getResourceCount(Random random) {
        return 1;
    }

    public int getResource(int n, Random random) {
        return Tile.treeTrunk.id;
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        int n4 = 4;
        int n5 = n4 + 1;
        if (level.hasChunksAt(n - n5, n2 - n5, n3 - n5, n + n5, n2 + n5, n3 + n5)) {
            for (int i = -n4; i <= n4; ++i) {
                for (int j = -n4; j <= n4; ++j) {
                    for (int k = -n4; k <= n4; ++k) {
                        int n6;
                        int n7 = level.getTile(n + i, n2 + j, n3 + k);
                        if (n7 != Tile.leaves.id || ((n6 = level.getData(n + i, n2 + j, n3 + k)) & 4) != 0) continue;
                        level.setDataNoUpdate(n + i, n2 + j, n3 + k, n6 | 4);
                    }
                }
            }
        }
    }

    public int getTexture(int n, int n2) {
        if (n == 1) {
            return 21;
        }
        if (n == 0) {
            return 21;
        }
        if (n2 == 1) {
            return 116;
        }
        if (n2 == 2) {
            return 117;
        }
        return 20;
    }

    protected int getSpawnResourcesAuxValue(int n) {
        return n;
    }
}

