/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TorchTile
extends Tile {
    protected TorchTile(int n, int n2) {
        super(n, n2, Material.decoration);
        this.setTicking(true);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 2;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (level.isSolidTile(n - 1, n2, n3)) {
            return true;
        }
        if (level.isSolidTile(n + 1, n2, n3)) {
            return true;
        }
        if (level.isSolidTile(n, n2, n3 - 1)) {
            return true;
        }
        if (level.isSolidTile(n, n2, n3 + 1)) {
            return true;
        }
        return level.isSolidTile(n, n2 - 1, n3);
    }

    public void setPlacedOnFace(Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getData(n, n2, n3);
        if (n4 == 1 && level.isSolidTile(n, n2 - 1, n3)) {
            n5 = 5;
        }
        if (n4 == 2 && level.isSolidTile(n, n2, n3 + 1)) {
            n5 = 4;
        }
        if (n4 == 3 && level.isSolidTile(n, n2, n3 - 1)) {
            n5 = 3;
        }
        if (n4 == 4 && level.isSolidTile(n + 1, n2, n3)) {
            n5 = 2;
        }
        if (n4 == 5 && level.isSolidTile(n - 1, n2, n3)) {
            n5 = 1;
        }
        level.setData(n, n2, n3, n5);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        super.tick(level, n, n2, n3, random);
        if (level.getData(n, n2, n3) == 0) {
            this.onPlace(level, n, n2, n3);
        }
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        if (level.isSolidTile(n - 1, n2, n3)) {
            level.setData(n, n2, n3, 1);
        } else if (level.isSolidTile(n + 1, n2, n3)) {
            level.setData(n, n2, n3, 2);
        } else if (level.isSolidTile(n, n2, n3 - 1)) {
            level.setData(n, n2, n3, 3);
        } else if (level.isSolidTile(n, n2, n3 + 1)) {
            level.setData(n, n2, n3, 4);
        } else if (level.isSolidTile(n, n2 - 1, n3)) {
            level.setData(n, n2, n3, 5);
        }
        this.checkCanSurvive(level, n, n2, n3);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (this.checkCanSurvive(level, n, n2, n3)) {
            int n5 = level.getData(n, n2, n3);
            boolean bl = false;
            if (!level.isSolidTile(n - 1, n2, n3) && n5 == 1) {
                bl = true;
            }
            if (!level.isSolidTile(n + 1, n2, n3) && n5 == 2) {
                bl = true;
            }
            if (!level.isSolidTile(n, n2, n3 - 1) && n5 == 3) {
                bl = true;
            }
            if (!level.isSolidTile(n, n2, n3 + 1) && n5 == 4) {
                bl = true;
            }
            if (!level.isSolidTile(n, n2 - 1, n3) && n5 == 5) {
                bl = true;
            }
            if (bl) {
                this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
                level.setTile(n, n2, n3, 0);
            }
        }
    }

    private boolean checkCanSurvive(Level level, int n, int n2, int n3) {
        if (!this.mayPlace(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
            return false;
        }
        return true;
    }

    public HitResult clip(Level level, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        int n4 = level.getData(n, n2, n3) & 7;
        float f = 0.15f;
        if (n4 == 1) {
            this.setShape(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (n4 == 2) {
            this.setShape(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (n4 == 3) {
            this.setShape(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (n4 == 4) {
            this.setShape(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            f = 0.1f;
            this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.6f, 0.5f + f);
        }
        return super.clip(level, n, n2, n3, vec3, vec32);
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        int n4 = level.getData(n, n2, n3);
        double d = (float)n + 0.5f;
        double d2 = (float)n2 + 0.7f;
        double d3 = (float)n3 + 0.5f;
        double d4 = 0.22f;
        double d5 = 0.27f;
        if (n4 == 1) {
            level.addParticle("smoke", d - d5, d2 + d4, d3, 0.0, 0.0, 0.0);
            level.addParticle("flame", d - d5, d2 + d4, d3, 0.0, 0.0, 0.0);
        } else if (n4 == 2) {
            level.addParticle("smoke", d + d5, d2 + d4, d3, 0.0, 0.0, 0.0);
            level.addParticle("flame", d + d5, d2 + d4, d3, 0.0, 0.0, 0.0);
        } else if (n4 == 3) {
            level.addParticle("smoke", d, d2 + d4, d3 - d5, 0.0, 0.0, 0.0);
            level.addParticle("flame", d, d2 + d4, d3 - d5, 0.0, 0.0, 0.0);
        } else if (n4 == 4) {
            level.addParticle("smoke", d, d2 + d4, d3 + d5, 0.0, 0.0, 0.0);
            level.addParticle("flame", d, d2 + d4, d3 + d5, 0.0, 0.0, 0.0);
        } else {
            level.addParticle("smoke", d, d2, d3, 0.0, 0.0, 0.0);
            level.addParticle("flame", d, d2, d3, 0.0, 0.0, 0.0);
        }
    }
}

