/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class TopSnowTile
extends Tile {
    protected TopSnowTile(int n, int n2) {
        super(n, n2, Material.topSnow);
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTicking(true);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2 - 1, n3);
        if (n4 == 0 || !Tile.tiles[n4].isSolidRender()) {
            return false;
        }
        return level.getMaterial(n, n2 - 1, n3).blocksMotion();
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        this.checkCanSurvive(level, n, n2, n3);
    }

    private boolean checkCanSurvive(Level level, int n, int n2, int n3) {
        if (!this.mayPlace(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
            return false;
        }
        return true;
    }

    public void playerDestroy(Level level, int n, int n2, int n3, int n4) {
        int n5 = Item.snowBall.id;
        float f = 0.7f;
        double d = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ItemEntity itemEntity = new ItemEntity(level, (double)n + d, (double)n2 + d2, (double)n3 + d3, new ItemInstance(n5, 1, 0));
        itemEntity.throwTime = 10;
        level.addEntity(itemEntity);
        level.setTile(n, n2, n3, 0);
    }

    public int getResource(int n, Random random) {
        return Item.snowBall.id;
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.getBrightness(LightLayer.Block, n, n2, n3) > 11) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
    }

    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        Material material = levelSource.getMaterial(n, n2, n3);
        if (n4 == 1) {
            return true;
        }
        if (material == this.material) {
            return false;
        }
        return super.shouldRenderFace(levelSource, n, n2, n3, n4);
    }
}

