/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class TntTile
extends Tile {
    public TntTile(int n, int n2) {
        super(n, n2, Material.explosive);
    }

    public int getTexture(int n) {
        if (n == 0) {
            return this.tex + 2;
        }
        if (n == 1) {
            return this.tex + 1;
        }
        return this.tex;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Tile.tiles[n4].isSignalSource() && level.hasNeighborSignal(n, n2, n3)) {
            this.destroy(level, n, n2, n3, 0);
            level.setTile(n, n2, n3, 0);
        }
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    public void wasExploded(Level level, int n, int n2, int n3) {
        PrimedTnt primedTnt = new PrimedTnt(level, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f);
        primedTnt.life = level.random.nextInt(primedTnt.life / 4) + primedTnt.life / 8;
        level.addEntity(primedTnt);
    }

    public void destroy(Level level, int n, int n2, int n3, int n4) {
        if (level.isOnline) {
            return;
        }
        PrimedTnt primedTnt = new PrimedTnt(level, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f);
        level.addEntity(primedTnt);
        level.playSound(primedTnt, "random.fuse", 1.0f, 1.0f);
    }
}

