/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.locale.Descriptive;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ClothTileItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.TileItem;
import net.minecraft.world.item.TreeTileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.BookshelfTile;
import net.minecraft.world.level.tile.Bush;
import net.minecraft.world.level.tile.ButtonTile;
import net.minecraft.world.level.tile.CactusTile;
import net.minecraft.world.level.tile.CakeTile;
import net.minecraft.world.level.tile.ChestTile;
import net.minecraft.world.level.tile.ClayTile;
import net.minecraft.world.level.tile.ClothTile;
import net.minecraft.world.level.tile.CropTile;
import net.minecraft.world.level.tile.DirtTile;
import net.minecraft.world.level.tile.DispenserTile;
import net.minecraft.world.level.tile.DoorTile;
import net.minecraft.world.level.tile.FarmTile;
import net.minecraft.world.level.tile.FenceTile;
import net.minecraft.world.level.tile.FireTile;
import net.minecraft.world.level.tile.FurnaceTile;
import net.minecraft.world.level.tile.GlassTile;
import net.minecraft.world.level.tile.GrassTile;
import net.minecraft.world.level.tile.GravelTile;
import net.minecraft.world.level.tile.HellSandTile;
import net.minecraft.world.level.tile.HellStoneTile;
import net.minecraft.world.level.tile.IceTile;
import net.minecraft.world.level.tile.LadderTile;
import net.minecraft.world.level.tile.LeafTile;
import net.minecraft.world.level.tile.LeverTile;
import net.minecraft.world.level.tile.LightGemTile;
import net.minecraft.world.level.tile.LiquidTileDynamic;
import net.minecraft.world.level.tile.LiquidTileStatic;
import net.minecraft.world.level.tile.MetalTile;
import net.minecraft.world.level.tile.MobSpawnerTile;
import net.minecraft.world.level.tile.Mushroom;
import net.minecraft.world.level.tile.MusicTile;
import net.minecraft.world.level.tile.NotGateTile;
import net.minecraft.world.level.tile.ObsidianTile;
import net.minecraft.world.level.tile.OreTile;
import net.minecraft.world.level.tile.PortalTile;
import net.minecraft.world.level.tile.PressurePlateTile;
import net.minecraft.world.level.tile.PumpkinTile;
import net.minecraft.world.level.tile.RailTile;
import net.minecraft.world.level.tile.RecordPlayerTile;
import net.minecraft.world.level.tile.RedStoneDustTile;
import net.minecraft.world.level.tile.RedStoneOreTile;
import net.minecraft.world.level.tile.ReedTile;
import net.minecraft.world.level.tile.SandStoneTile;
import net.minecraft.world.level.tile.SandTile;
import net.minecraft.world.level.tile.Sapling;
import net.minecraft.world.level.tile.SignTile;
import net.minecraft.world.level.tile.SnowTile;
import net.minecraft.world.level.tile.Sponge;
import net.minecraft.world.level.tile.StairTile;
import net.minecraft.world.level.tile.StoneSlabTile;
import net.minecraft.world.level.tile.StoneTile;
import net.minecraft.world.level.tile.TntTile;
import net.minecraft.world.level.tile.TopSnowTile;
import net.minecraft.world.level.tile.TorchTile;
import net.minecraft.world.level.tile.TreeTile;
import net.minecraft.world.level.tile.WorkbenchTile;
import net.minecraft.world.level.tile.entity.SignTileEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile
implements Descriptive<Tile> {
    private static final String TILE_DESCRIPTION_PREFIX = "tile.";
    public static final SoundType SOUND_NORMAL = new SoundType("stone", 1.0f, 1.0f);
    public static final SoundType SOUND_WOOD = new SoundType("wood", 1.0f, 1.0f);
    public static final SoundType SOUND_GRAVEL = new SoundType("gravel", 1.0f, 1.0f);
    public static final SoundType SOUND_GRASS = new SoundType("grass", 1.0f, 1.0f);
    public static final SoundType SOUND_STONE = new SoundType("stone", 1.0f, 1.0f);
    public static final SoundType SOUND_METAL = new SoundType("stone", 1.0f, 1.5f);
    public static final SoundType SOUND_GLASS = new SoundType("stone", 1.0f, 1.0f){

        public String getBreakSound() {
            return "random.glass";
        }
    };
    public static final SoundType SOUND_CLOTH = new SoundType("cloth", 1.0f, 1.0f);
    public static final SoundType SOUND_SAND = new SoundType("sand", 1.0f, 1.0f){

        public String getBreakSound() {
            return "step.gravel";
        }
    };
    public static final int SHAPE_INVISIBLE = -1;
    public static final int SHAPE_BLOCK = 0;
    public static final int SHAPE_CROSS_TEXTURE = 1;
    public static final int SHAPE_TORCH = 2;
    public static final int SHAPE_FIRE = 3;
    public static final int SHAPE_WATER = 4;
    public static final int SHAPE_RED_DUST = 5;
    public static final int SHAPE_ROWS = 6;
    public static final int SHAPE_DOOR = 7;
    public static final int SHAPE_LADDER = 8;
    public static final int SHAPE_RAIL = 9;
    public static final int SHAPE_STAIRS = 10;
    public static final int SHAPE_FENCE = 11;
    public static final int SHAPE_LEVER = 12;
    public static final int SHAPE_CACTUS = 13;
    public static final Tile[] tiles = new Tile[256];
    public static final boolean[] shouldTick = new boolean[256];
    public static final boolean[] solid = new boolean[256];
    public static final boolean[] isEntityTile = new boolean[256];
    public static final int[] lightBlock = new int[256];
    public static final boolean[] transculent = new boolean[256];
    public static final int[] lightEmission = new int[256];
    public static final Tile rock = new StoneTile(1, 1).setDestroyTime(1.5f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("stone");
    public static final GrassTile grass = (GrassTile)new GrassTile(2).setDestroyTime(0.6f).setSoundType(SOUND_GRASS).setDescriptionId("grass");
    public static final Tile dirt = new DirtTile(3, 2).setDestroyTime(0.5f).setSoundType(SOUND_GRAVEL).setDescriptionId("dirt");
    public static final Tile stoneBrick = new Tile(4, 16, Material.stone).setDestroyTime(2.0f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("stonebrick");
    public static final Tile wood = new Tile(5, 4, Material.wood).setDestroyTime(2.0f).setExplodeable(5.0f).setSoundType(SOUND_WOOD).setDescriptionId("wood");
    public static final Tile sapling = new Sapling(6, 15).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("sapling");
    public static final Tile unbreakable = new Tile(7, 17, Material.stone).setDestroyTime(-1.0f).setExplodeable(6000000.0f).setSoundType(SOUND_STONE).setDescriptionId("bedrock");
    public static final Tile water = new LiquidTileDynamic(8, Material.water).setDestroyTime(100.0f).setLightBlock(3).setDescriptionId("water");
    public static final Tile calmWater = new LiquidTileStatic(9, Material.water).setDestroyTime(100.0f).setLightBlock(3).setDescriptionId("water");
    public static final Tile lava = new LiquidTileDynamic(10, Material.lava).setDestroyTime(0.0f).setLightEmission(1.0f).setLightBlock(255).setDescriptionId("lava");
    public static final Tile calmLava = new LiquidTileStatic(11, Material.lava).setDestroyTime(100.0f).setLightEmission(1.0f).setLightBlock(255).setDescriptionId("lava");
    public static final Tile sand = new SandTile(12, 18).setDestroyTime(0.5f).setSoundType(SOUND_SAND).setDescriptionId("sand");
    public static final Tile gravel = new GravelTile(13, 19).setDestroyTime(0.6f).setSoundType(SOUND_GRAVEL).setDescriptionId("gravel");
    public static final Tile goldOre = new OreTile(14, 32).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreGold");
    public static final Tile ironOre = new OreTile(15, 33).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreIron");
    public static final Tile coalOre = new OreTile(16, 34).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreCoal");
    public static final Tile treeTrunk = new TreeTile(17).setDestroyTime(2.0f).setSoundType(SOUND_WOOD).setDescriptionId("log");
    public static final LeafTile leaves = (LeafTile)new LeafTile(18, 52).setDestroyTime(0.2f).setLightBlock(1).setSoundType(SOUND_GRASS).setDescriptionId("leaves");
    public static final Tile sponge = new Sponge(19).setDestroyTime(0.6f).setSoundType(SOUND_GRASS).setDescriptionId("sponge");
    public static final Tile glass = new GlassTile(20, 49, Material.glass, false).setDestroyTime(0.3f).setSoundType(SOUND_GLASS).setDescriptionId("glass");
    public static final Tile lapisOre = new OreTile(21, 160).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreLapis");
    public static final Tile lapisBlock = new Tile(22, 144, Material.stone).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("blockLapis");
    public static final Tile dispenser = new DispenserTile(23).setDestroyTime(3.5f).setSoundType(SOUND_STONE).setDescriptionId("dispenser");
    public static final Tile sandStone = new SandStoneTile(24).setSoundType(SOUND_STONE).setDestroyTime(0.8f).setDescriptionId("sandStone");
    public static final Tile musicBlock = new MusicTile(25).setDestroyTime(0.8f).setDescriptionId("musicBlock");
    public static final Tile unused_26 = null;
    public static final Tile unused_27 = null;
    public static final Tile unused_28 = null;
    public static final Tile unused_29 = null;
    public static final Tile unused_30 = null;
    public static final Tile unused_31 = null;
    public static final Tile unused_32 = null;
    public static final Tile unused_33 = null;
    public static final Tile unused_34 = null;
    public static final Tile cloth = new ClothTile().setDestroyTime(0.8f).setSoundType(SOUND_CLOTH).setDescriptionId("cloth");
    public static final Tile unused_36 = null;
    public static final Bush flower = (Bush)new Bush(37, 13).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("flower");
    public static final Bush rose = (Bush)new Bush(38, 12).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("rose");
    public static final Bush mushroom1 = (Bush)new Mushroom(39, 29).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setLightEmission(0.125f).setDescriptionId("mushroom");
    public static final Bush mushroom2 = (Bush)new Mushroom(40, 28).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("mushroom");
    public static final Tile goldBlock = new MetalTile(41, 23).setDestroyTime(3.0f).setExplodeable(10.0f).setSoundType(SOUND_METAL).setDescriptionId("blockGold");
    public static final Tile ironBlock = new MetalTile(42, 22).setDestroyTime(5.0f).setExplodeable(10.0f).setSoundType(SOUND_METAL).setDescriptionId("blockIron");
    public static final Tile stoneSlab = new StoneSlabTile(43, true).setDestroyTime(2.0f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("stoneSlab");
    public static final Tile stoneSlabHalf = new StoneSlabTile(44, false).setDestroyTime(2.0f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("stoneSlab");
    public static final Tile redBrick = new Tile(45, 7, Material.stone).setDestroyTime(2.0f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("brick");
    public static final Tile tnt = new TntTile(46, 8).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("tnt");
    public static final Tile bookshelf = new BookshelfTile(47, 35).setDestroyTime(1.5f).setSoundType(SOUND_WOOD).setDescriptionId("bookshelf");
    public static final Tile mossStone = new Tile(48, 36, Material.stone).setDestroyTime(2.0f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("stoneMoss");
    public static final Tile obsidian = new ObsidianTile(49, 37).setDestroyTime(10.0f).setExplodeable(2000.0f).setSoundType(SOUND_STONE).setDescriptionId("obsidian");
    public static final Tile torch = new TorchTile(50, 80).setDestroyTime(0.0f).setLightEmission(0.9375f).setSoundType(SOUND_WOOD).setDescriptionId("torch");
    public static final FireTile fire = (FireTile)new FireTile(51, 31).setDestroyTime(0.0f).setLightEmission(1.0f).setSoundType(SOUND_WOOD).setDescriptionId("fire");
    public static final Tile mobSpawner = new MobSpawnerTile(52, 65).setDestroyTime(5.0f).setSoundType(SOUND_METAL).setDescriptionId("mobSpawner");
    public static final Tile stairs_wood = new StairTile(53, wood).setDescriptionId("stairsWood");
    public static final Tile chest = new ChestTile(54).setDestroyTime(2.5f).setSoundType(SOUND_WOOD).setDescriptionId("chest");
    public static final Tile redStoneDust = new RedStoneDustTile(55, 84).setDestroyTime(0.0f).setSoundType(SOUND_NORMAL).setDescriptionId("redstoneDust");
    public static final Tile emeraldOre = new OreTile(56, 50).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreDiamond");
    public static final Tile emeraldBlock = new MetalTile(57, 24).setDestroyTime(5.0f).setExplodeable(10.0f).setSoundType(SOUND_METAL).setDescriptionId("blockDiamond");
    public static final Tile workBench = new WorkbenchTile(58).setDestroyTime(2.5f).setSoundType(SOUND_WOOD).setDescriptionId("workbench");
    public static final Tile crops = new CropTile(59, 88).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("crops");
    public static final Tile farmland = new FarmTile(60).setDestroyTime(0.6f).setSoundType(SOUND_GRAVEL).setDescriptionId("farmland");
    public static final Tile furnace = new FurnaceTile(61, false).setDestroyTime(3.5f).setSoundType(SOUND_STONE).setDescriptionId("furnace");
    public static final Tile furnace_lit = new FurnaceTile(62, true).setDestroyTime(3.5f).setSoundType(SOUND_STONE).setLightEmission(0.875f).setDescriptionId("furnace");
    public static final Tile sign = new SignTile(63, SignTileEntity.class, true).setDestroyTime(1.0f).setSoundType(SOUND_WOOD).setDescriptionId("sign");
    public static final Tile door_wood = new DoorTile(64, Material.wood).setDestroyTime(3.0f).setSoundType(SOUND_WOOD).setDescriptionId("doorWood");
    public static final Tile ladder = new LadderTile(65, 83).setDestroyTime(0.4f).setSoundType(SOUND_WOOD).setDescriptionId("ladder");
    public static final Tile rail = new RailTile(66, 128).setDestroyTime(0.7f).setSoundType(SOUND_METAL).setDescriptionId("rail");
    public static final Tile stairs_stone = new StairTile(67, stoneBrick).setDescriptionId("stairsStone");
    public static final Tile wallSign = new SignTile(68, SignTileEntity.class, false).setDestroyTime(1.0f).setSoundType(SOUND_WOOD).setDescriptionId("sign");
    public static final Tile lever = new LeverTile(69, 96).setDestroyTime(0.5f).setSoundType(SOUND_WOOD).setDescriptionId("lever");
    public static final Tile pressurePlate_stone = new PressurePlateTile(70, Tile.rock.tex, PressurePlateTile.Sensitivity.mobs).setDestroyTime(0.5f).setSoundType(SOUND_STONE).setDescriptionId("pressurePlate");
    public static final Tile door_iron = new DoorTile(71, Material.metal).setDestroyTime(5.0f).setSoundType(SOUND_METAL).setDescriptionId("doorIron");
    public static final Tile pressurePlate_wood = new PressurePlateTile(72, Tile.wood.tex, PressurePlateTile.Sensitivity.everything).setDestroyTime(0.5f).setSoundType(SOUND_WOOD).setDescriptionId("pressurePlate");
    public static final Tile redStoneOre = new RedStoneOreTile(73, 51, false).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreRedstone");
    public static final Tile redStoneOre_lit = new RedStoneOreTile(74, 51, true).setLightEmission(0.625f).setDestroyTime(3.0f).setExplodeable(5.0f).setSoundType(SOUND_STONE).setDescriptionId("oreRedstone");
    public static final Tile notGate_off = new NotGateTile(75, 115, false).setDestroyTime(0.0f).setSoundType(SOUND_WOOD).setDescriptionId("notGate");
    public static final Tile notGate_on = new NotGateTile(76, 99, true).setDestroyTime(0.0f).setLightEmission(0.5f).setSoundType(SOUND_WOOD).setDescriptionId("notGate");
    public static final Tile button = new ButtonTile(77, Tile.rock.tex).setDestroyTime(0.5f).setSoundType(SOUND_STONE).setDescriptionId("button");
    public static final Tile topSnow = new TopSnowTile(78, 66).setDestroyTime(0.1f).setSoundType(SOUND_CLOTH).setDescriptionId("snow");
    public static final Tile ice = new IceTile(79, 67).setDestroyTime(0.5f).setLightBlock(3).setSoundType(SOUND_GLASS).setDescriptionId("ice");
    public static final Tile snow = new SnowTile(80, 66).setDestroyTime(0.2f).setSoundType(SOUND_CLOTH).setDescriptionId("snow");
    public static final Tile cactus = new CactusTile(81, 70).setDestroyTime(0.4f).setSoundType(SOUND_CLOTH).setDescriptionId("cactus");
    public static final Tile clay = new ClayTile(82, 72).setDestroyTime(0.6f).setSoundType(SOUND_GRAVEL).setDescriptionId("clay");
    public static final Tile reeds = new ReedTile(83, 73).setDestroyTime(0.0f).setSoundType(SOUND_GRASS).setDescriptionId("reeds");
    public static final Tile recordPlayer = new RecordPlayerTile(84, 74).setDestroyTime(2.0f).setExplodeable(10.0f).setSoundType(SOUND_STONE).setDescriptionId("jukebox");
    public static final Tile fence = new FenceTile(85, 4).setDestroyTime(2.0f).setExplodeable(5.0f).setSoundType(SOUND_WOOD).setDescriptionId("fence");
    public static final Tile pumpkin = new PumpkinTile(86, 102, false).setDestroyTime(1.0f).setSoundType(SOUND_WOOD).setDescriptionId("pumpkin");
    public static final Tile hellRock = new HellStoneTile(87, 103).setDestroyTime(0.4f).setSoundType(SOUND_STONE).setDescriptionId("hellrock");
    public static final Tile hellSand = new HellSandTile(88, 104).setDestroyTime(0.5f).setSoundType(SOUND_SAND).setDescriptionId("hellsand");
    public static final Tile lightGem = new LightGemTile(89, 105, Material.glass).setDestroyTime(0.3f).setSoundType(SOUND_GLASS).setLightEmission(1.0f).setDescriptionId("lightgem");
    public static final PortalTile portalTile = (PortalTile)new PortalTile(90, 14).setDestroyTime(-1.0f).setSoundType(SOUND_GLASS).setLightEmission(0.75f).setDescriptionId("portal");
    public static final Tile litPumpkin = new PumpkinTile(91, 102, true).setDestroyTime(1.0f).setSoundType(SOUND_WOOD).setLightEmission(1.0f).setDescriptionId("litpumpkin");
    public static final Tile cake = new CakeTile(92, 121).setDestroyTime(0.5f).setSoundType(SOUND_CLOTH).setDescriptionId("cake");
    public int tex;
    public final int id;
    protected float destroySpeed;
    protected float explosionResistance;
    public double xx0;
    public double yy0;
    public double zz0;
    public double xx1;
    public double yy1;
    public double zz1;
    public SoundType soundType = SOUND_NORMAL;
    public float gravity = 1.0f;
    public final Material material;
    public float friction = 0.6f;
    private String descriptionId;

    protected Tile(int n, Material material) {
        if (tiles[n] != null) {
            throw new IllegalArgumentException("Slot " + n + " is already occupied by " + tiles[n] + " when adding " + this);
        }
        this.material = material;
        Tile.tiles[n] = this;
        this.id = n;
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Tile.solid[n] = this.isSolidRender();
        Tile.lightBlock[n] = this.isSolidRender() ? 255 : 0;
        Tile.transculent[n] = this.isTransculent();
        Tile.isEntityTile[n] = false;
    }

    protected Tile(int n, int n2, Material material) {
        this(n, material);
        this.tex = n2;
    }

    protected Tile setSoundType(SoundType soundType) {
        this.soundType = soundType;
        return this;
    }

    protected Tile setLightBlock(int n) {
        Tile.lightBlock[this.id] = n;
        return this;
    }

    protected Tile setLightEmission(float f) {
        Tile.lightEmission[this.id] = (int)(15.0f * f);
        return this;
    }

    protected Tile setExplodeable(float f) {
        this.explosionResistance = f * 3.0f;
        return this;
    }

    private boolean isTransculent() {
        return false;
    }

    public boolean isCubeShaped() {
        return true;
    }

    public int getRenderShape() {
        return 0;
    }

    protected Tile setDestroyTime(float f) {
        this.destroySpeed = f;
        if (this.explosionResistance < f * 5.0f) {
            this.explosionResistance = f * 5.0f;
        }
        return this;
    }

    protected void setTicking(boolean bl) {
        Tile.shouldTick[this.id] = bl;
    }

    public void setShape(float f, float f2, float f3, float f4, float f5, float f6) {
        this.xx0 = f;
        this.yy0 = f2;
        this.zz0 = f3;
        this.xx1 = f4;
        this.yy1 = f5;
        this.zz1 = f6;
    }

    public float getBrightness(LevelSource levelSource, int n, int n2, int n3) {
        return levelSource.getBrightness(n, n2, n3);
    }

    public static boolean isFaceVisible(Level level, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            --n2;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        return !level.isSolidTile(n, n2, n3);
    }

    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (n4 == 0 && this.yy0 > 0.0) {
            return true;
        }
        if (n4 == 1 && this.yy1 < 1.0) {
            return true;
        }
        if (n4 == 2 && this.zz0 > 0.0) {
            return true;
        }
        if (n4 == 3 && this.zz1 < 1.0) {
            return true;
        }
        if (n4 == 4 && this.xx0 > 0.0) {
            return true;
        }
        if (n4 == 5 && this.xx1 < 1.0) {
            return true;
        }
        return !levelSource.isSolidTile(n, n2, n3);
    }

    public int getTexture(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return this.getTexture(n4, levelSource.getData(n, n2, n3));
    }

    public int getTexture(int n, int n2) {
        return this.getTexture(n);
    }

    public int getTexture(int n) {
        return this.tex;
    }

    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        return AABB.newTemp((double)n + this.xx0, (double)n2 + this.yy0, (double)n3 + this.zz0, (double)n + this.xx1, (double)n2 + this.yy1, (double)n3 + this.zz1);
    }

    public void addAABBs(Level level, int n, int n2, int n3, AABB aABB, ArrayList<AABB> arrayList) {
        AABB aABB2 = this.getAABB(level, n, n2, n3);
        if (aABB2 != null && aABB.intersects(aABB2)) {
            arrayList.add(aABB2);
        }
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return AABB.newTemp((double)n + this.xx0, (double)n2 + this.yy0, (double)n3 + this.zz0, (double)n + this.xx1, (double)n2 + this.yy1, (double)n3 + this.zz1);
    }

    public boolean isSolidRender() {
        return true;
    }

    public boolean mayPick(int n, boolean bl) {
        return this.mayPick();
    }

    public boolean mayPick() {
        return true;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
    }

    public void destroy(Level level, int n, int n2, int n3, int n4) {
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
    }

    public void addLights(Level level, int n, int n2, int n3) {
    }

    public int getTickDelay() {
        return 10;
    }

    public void onPlace(Level level, int n, int n2, int n3) {
    }

    public void onRemove(Level level, int n, int n2, int n3) {
    }

    public int getResourceCount(Random random) {
        return 1;
    }

    public int getResource(int n, Random random) {
        return this.id;
    }

    public float getDestroyProgress(Player player) {
        if (this.destroySpeed < 0.0f) {
            return 0.0f;
        }
        if (!player.canDestroy(this)) {
            return 1.0f / this.destroySpeed / 100.0f;
        }
        return player.getDestroySpeed(this) / this.destroySpeed / 30.0f;
    }

    public void spawnResources(Level level, int n, int n2, int n3, int n4) {
        this.spawnResources(level, n, n2, n3, n4, 1.0f);
    }

    public void spawnResources(Level level, int n, int n2, int n3, int n4, float f) {
        if (level.isOnline) {
            return;
        }
        int n5 = this.getResourceCount(level.random);
        for (int i = 0; i < n5; ++i) {
            int n6;
            if (level.random.nextFloat() > f || (n6 = this.getResource(n4, level.random)) <= 0) continue;
            float f2 = 0.7f;
            double d = (double)(level.random.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            double d2 = (double)(level.random.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            double d3 = (double)(level.random.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
            ItemEntity itemEntity = new ItemEntity(level, (double)n + d, (double)n2 + d2, (double)n3 + d3, new ItemInstance(n6, 1, this.getSpawnResourcesAuxValue(n4)));
            itemEntity.throwTime = 10;
            level.addEntity(itemEntity);
        }
    }

    protected int getSpawnResourcesAuxValue(int n) {
        return 0;
    }

    public float getExplosionResistance(Entity entity) {
        return this.explosionResistance / 5.0f;
    }

    public HitResult clip(Level level, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.updateShape(level, n, n2, n3);
        vec3 = vec3.add(-n, -n2, -n3);
        vec32 = vec32.add(-n, -n2, -n3);
        Vec3 vec33 = vec3.clipX(vec32, this.xx0);
        Vec3 vec34 = vec3.clipX(vec32, this.xx1);
        Vec3 vec35 = vec3.clipY(vec32, this.yy0);
        Vec3 vec36 = vec3.clipY(vec32, this.yy1);
        Vec3 vec37 = vec3.clipZ(vec32, this.zz0);
        Vec3 vec38 = vec3.clipZ(vec32, this.zz1);
        if (!this.containsX(vec33)) {
            vec33 = null;
        }
        if (!this.containsX(vec34)) {
            vec34 = null;
        }
        if (!this.containsY(vec35)) {
            vec35 = null;
        }
        if (!this.containsY(vec36)) {
            vec36 = null;
        }
        if (!this.containsZ(vec37)) {
            vec37 = null;
        }
        if (!this.containsZ(vec38)) {
            vec38 = null;
        }
        Vec3 vec39 = null;
        if (vec33 != null && (vec39 == null || vec3.distanceTo(vec33) < vec3.distanceTo(vec39))) {
            vec39 = vec33;
        }
        if (vec34 != null && (vec39 == null || vec3.distanceTo(vec34) < vec3.distanceTo(vec39))) {
            vec39 = vec34;
        }
        if (vec35 != null && (vec39 == null || vec3.distanceTo(vec35) < vec3.distanceTo(vec39))) {
            vec39 = vec35;
        }
        if (vec36 != null && (vec39 == null || vec3.distanceTo(vec36) < vec3.distanceTo(vec39))) {
            vec39 = vec36;
        }
        if (vec37 != null && (vec39 == null || vec3.distanceTo(vec37) < vec3.distanceTo(vec39))) {
            vec39 = vec37;
        }
        if (vec38 != null && (vec39 == null || vec3.distanceTo(vec38) < vec3.distanceTo(vec39))) {
            vec39 = vec38;
        }
        if (vec39 == null) {
            return null;
        }
        int n4 = -1;
        if (vec39 == vec33) {
            n4 = 4;
        }
        if (vec39 == vec34) {
            n4 = 5;
        }
        if (vec39 == vec35) {
            n4 = 0;
        }
        if (vec39 == vec36) {
            n4 = 1;
        }
        if (vec39 == vec37) {
            n4 = 2;
        }
        if (vec39 == vec38) {
            n4 = 3;
        }
        return new HitResult(n, n2, n3, n4, vec39.add(n, n2, n3));
    }

    private boolean containsX(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.y >= this.yy0 && vec3.y <= this.yy1 && vec3.z >= this.zz0 && vec3.z <= this.zz1;
    }

    private boolean containsY(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x >= this.xx0 && vec3.x <= this.xx1 && vec3.z >= this.zz0 && vec3.z <= this.zz1;
    }

    private boolean containsZ(Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.x >= this.xx0 && vec3.x <= this.xx1 && vec3.y >= this.yy0 && vec3.y <= this.yy1;
    }

    public void wasExploded(Level level, int n, int n2, int n3) {
    }

    public int getRenderLayer() {
        return 0;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3);
        return n4 == 0 || Tile.tiles[n4].material.isLiquid();
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        return false;
    }

    public final boolean spawnBurnResources(Level level, float f, float f2, float f3) {
        return false;
    }

    public void stepOn(Level level, int n, int n2, int n3, Entity entity) {
    }

    public void setPlacedOnFace(Level level, int n, int n2, int n3, int n4) {
    }

    public void prepareRender(Level level, int n, int n2, int n3) {
    }

    public void attack(Level level, int n, int n2, int n3, Player player) {
    }

    public void handleEntityInside(Level level, int n, int n2, int n3, Entity entity, Vec3 vec3) {
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
    }

    public int getColor(LevelSource levelSource, int n, int n2, int n3) {
        return 0xFFFFFF;
    }

    public final boolean getSignal(LevelSource levelSource, int n, int n2, int n3) {
        return false;
    }

    public boolean getSignal(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return false;
    }

    public boolean isSignalSource() {
        return false;
    }

    public void entityInside(Level level, int n, int n2, int n3, Entity entity) {
    }

    public boolean getDirectSignal(Level level, int n, int n2, int n3, int n4) {
        return false;
    }

    public void updateDefaultShape() {
    }

    public void playerDestroy(Level level, int n, int n2, int n3, int n4) {
        this.spawnResources(level, n, n2, n3, n4);
    }

    public boolean canSurvive(Level level, int n, int n2, int n3) {
        return true;
    }

    public void setPlacedBy(Level level, int n, int n2, int n3, Mob mob) {
    }

    @Override
    public Tile setDescriptionId(String string) {
        this.descriptionId = TILE_DESCRIPTION_PREFIX + string;
        return this;
    }

    @Override
    public String getDescriptionId() {
        return this.descriptionId;
    }

    public void triggerEvent(Level level, int n, int n2, int n3, int n4, int n5) {
    }

    static {
        Item.items[Tile.cloth.id] = new ClothTileItem(Tile.cloth.id - 256).setDescriptionId("cloth");
        Item.items[Tile.treeTrunk.id] = new TreeTileItem(Tile.treeTrunk.id - 256).setDescriptionId("log");
        for (int i = 0; i < 256; ++i) {
            if (tiles[i] == null || Item.items[i] != null) continue;
            Item.items[i] = new TileItem(i - 256);
        }
    }

    public static class SoundType {
        public final String name;
        public final float volume;
        public final float pitch;

        public SoundType(String string, float f, float f2) {
            this.name = string;
            this.volume = f;
            this.pitch = f2;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public String getBreakSound() {
            return "step." + this.name;
        }

        public String getStepSound() {
            return "step." + this.name;
        }
    }
}

