/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class StoneSlabTile
extends Tile {
    private boolean fullSize;

    public StoneSlabTile(int n, boolean bl) {
        super(n, 6, Material.stone);
        this.fullSize = bl;
        if (!bl) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.setLightBlock(255);
    }

    public int getTexture(int n) {
        if (n <= 1) {
            return 6;
        }
        return 5;
    }

    public boolean isSolidRender() {
        return this.fullSize;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (this != Tile.stoneSlabHalf) {
            return;
        }
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        int n4;
        if (this != Tile.stoneSlabHalf) {
            super.onPlace(level, n, n2, n3);
        }
        if ((n4 = level.getTile(n, n2 - 1, n3)) == StoneSlabTile.stoneSlabHalf.id) {
            level.setTile(n, n2, n3, 0);
            level.setTile(n, n2 - 1, n3, Tile.stoneSlab.id);
        }
    }

    public int getResource(int n, Random random) {
        return Tile.stoneSlabHalf.id;
    }

    public boolean isCubeShaped() {
        return this.fullSize;
    }

    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (this != Tile.stoneSlabHalf) {
            super.shouldRenderFace(levelSource, n, n2, n3, n4);
        }
        if (n4 == 1) {
            return true;
        }
        if (!super.shouldRenderFace(levelSource, n, n2, n3, n4)) {
            return false;
        }
        if (n4 == 0) {
            return true;
        }
        return levelSource.getTile(n, n2, n3) != this.id;
    }
}

