/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import util.Mth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StairTile
extends Tile {
    private Tile base;

    protected StairTile(int n, Tile tile) {
        super(n, tile.tex, tile.material);
        this.base = tile;
        this.setDestroyTime(tile.destroySpeed);
        this.setExplodeable(tile.explosionResistance / 3.0f);
        this.setSoundType(tile.soundType);
    }

    @Override
    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public AABB getAABB(Level level, int n, int n2, int n3) {
        return super.getAABB(level, n, n2, n3);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public int getRenderShape() {
        return 10;
    }

    @Override
    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return super.shouldRenderFace(levelSource, n, n2, n3, n4);
    }

    @Override
    public void addAABBs(Level level, int n, int n2, int n3, AABB aABB, ArrayList<AABB> arrayList) {
        int n4 = level.getData(n, n2, n3);
        if (n4 == 0) {
            this.setShape(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
            this.setShape(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
        } else if (n4 == 1) {
            this.setShape(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
            this.setShape(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
        } else if (n4 == 2) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
            this.setShape(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
        } else if (n4 == 3) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
            this.setShape(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.addAABBs(level, n, n2, n3, aABB, arrayList);
        }
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void addLights(Level level, int n, int n2, int n3) {
        this.base.addLights(level, n, n2, n3);
    }

    @Override
    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        this.base.animateTick(level, n, n2, n3, random);
    }

    @Override
    public void attack(Level level, int n, int n2, int n3, Player player) {
        this.base.attack(level, n, n2, n3, player);
    }

    @Override
    public void destroy(Level level, int n, int n2, int n3, int n4) {
        this.base.destroy(level, n, n2, n3, n4);
    }

    @Override
    public float getBrightness(LevelSource levelSource, int n, int n2, int n3) {
        return this.base.getBrightness(levelSource, n, n2, n3);
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        return this.base.getExplosionResistance(entity);
    }

    @Override
    public int getRenderLayer() {
        return this.base.getRenderLayer();
    }

    @Override
    public int getResource(int n, Random random) {
        return this.base.getResource(n, random);
    }

    @Override
    public int getResourceCount(Random random) {
        return this.base.getResourceCount(random);
    }

    @Override
    public int getTexture(int n, int n2) {
        return this.base.getTexture(n, n2);
    }

    @Override
    public int getTexture(int n) {
        return this.base.getTexture(n);
    }

    @Override
    public int getTexture(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return this.base.getTexture(levelSource, n, n2, n3, n4);
    }

    @Override
    public int getTickDelay() {
        return this.base.getTickDelay();
    }

    @Override
    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        return this.base.getTileAABB(level, n, n2, n3);
    }

    @Override
    public void handleEntityInside(Level level, int n, int n2, int n3, Entity entity, Vec3 vec3) {
        this.base.handleEntityInside(level, n, n2, n3, entity, vec3);
    }

    @Override
    public boolean mayPick() {
        return this.base.mayPick();
    }

    @Override
    public boolean mayPick(int n, boolean bl) {
        return this.base.mayPick(n, bl);
    }

    @Override
    public boolean mayPlace(Level level, int n, int n2, int n3) {
        return this.base.mayPlace(level, n, n2, n3);
    }

    @Override
    public void onPlace(Level level, int n, int n2, int n3) {
        this.neighborChanged(level, n, n2, n3, 0);
        this.base.onPlace(level, n, n2, n3);
    }

    @Override
    public void onRemove(Level level, int n, int n2, int n3) {
        this.base.onRemove(level, n, n2, n3);
    }

    @Override
    public void prepareRender(Level level, int n, int n2, int n3) {
        this.base.prepareRender(level, n, n2, n3);
    }

    @Override
    public void spawnResources(Level level, int n, int n2, int n3, int n4, float f) {
        this.base.spawnResources(level, n, n2, n3, n4, f);
    }

    @Override
    public void spawnResources(Level level, int n, int n2, int n3, int n4) {
        this.base.spawnResources(level, n, n2, n3, n4);
    }

    @Override
    public void stepOn(Level level, int n, int n2, int n3, Entity entity) {
        this.base.stepOn(level, n, n2, n3, entity);
    }

    @Override
    public void tick(Level level, int n, int n2, int n3, Random random) {
        this.base.tick(level, n, n2, n3, random);
    }

    @Override
    public boolean use(Level level, int n, int n2, int n3, Player player) {
        return this.base.use(level, n, n2, n3, player);
    }

    @Override
    public void wasExploded(Level level, int n, int n2, int n3) {
        this.base.wasExploded(level, n, n2, n3);
    }

    @Override
    public void setPlacedBy(Level level, int n, int n2, int n3, Mob mob) {
        int n4 = Mth.floor((double)(mob.yRot * 4.0f / 360.0f) + 0.5) & 3;
        if (n4 == 0) {
            level.setData(n, n2, n3, 2);
        }
        if (n4 == 1) {
            level.setData(n, n2, n3, 1);
        }
        if (n4 == 2) {
            level.setData(n, n2, n3, 3);
        }
        if (n4 == 3) {
            level.setData(n, n2, n3, 0);
        }
    }
}

