/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class SpringTile
extends Tile {
    private int liquidTileId;

    protected SpringTile(int n, int n2) {
        super(n, Tile.tiles[n2].tex, Material.water);
        this.liquidTileId = n2;
        this.setTicking(true);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        super.onPlace(level, n, n2, n3);
        if (level.isEmptyTile(n - 1, n2, n3)) {
            level.setTile(n - 1, n2, n3, this.liquidTileId);
        }
        if (level.isEmptyTile(n + 1, n2, n3)) {
            level.setTile(n + 1, n2, n3, this.liquidTileId);
        }
        if (level.isEmptyTile(n, n2, n3 - 1)) {
            level.setTile(n, n2, n3 - 1, this.liquidTileId);
        }
        if (level.isEmptyTile(n, n2, n3 + 1)) {
            level.setTile(n, n2, n3 + 1, this.liquidTileId);
        }
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        super.tick(level, n, n2, n3, random);
        if (level.isEmptyTile(n - 1, n2, n3)) {
            level.setTile(n - 1, n2, n3, this.liquidTileId);
        }
        if (level.isEmptyTile(n + 1, n2, n3)) {
            level.setTile(n + 1, n2, n3, this.liquidTileId);
        }
        if (level.isEmptyTile(n, n2, n3 - 1)) {
            level.setTile(n, n2, n3 - 1, this.liquidTileId);
        }
        if (level.isEmptyTile(n, n2, n3 + 1)) {
            level.setTile(n, n2, n3 + 1, this.liquidTileId);
        }
    }
}

