/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.EntityTile;
import net.minecraft.world.level.tile.entity.TileEntity;
import net.minecraft.world.phys.AABB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignTile
extends EntityTile {
    private Class<? extends TileEntity> clas;
    private boolean onGround;

    protected SignTile(int n, Class<? extends TileEntity> clazz, boolean bl) {
        super(n, Material.wood);
        this.onGround = bl;
        this.tex = 4;
        this.clas = clazz;
        float f = 0.25f;
        float f2 = 1.0f;
        this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f2, 0.5f + f);
    }

    @Override
    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    @Override
    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        this.updateShape(level, n, n2, n3);
        return super.getTileAABB(level, n, n2, n3);
    }

    @Override
    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        if (this.onGround) {
            return;
        }
        int n4 = levelSource.getData(n, n2, n3);
        float f = 0.28125f;
        float f2 = 0.78125f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 0.125f;
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (n4 == 2) {
            this.setShape(f3, f, 1.0f - f5, f4, f2, 1.0f);
        }
        if (n4 == 3) {
            this.setShape(f3, f, 0.0f, f4, f2, f5);
        }
        if (n4 == 4) {
            this.setShape(1.0f - f5, f, f3, 1.0f, f2, f4);
        }
        if (n4 == 5) {
            this.setShape(0.0f, f, f3, f5, f2, f4);
        }
    }

    @Override
    public int getRenderShape() {
        return -1;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    protected TileEntity newTileEntity() {
        try {
            return this.clas.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int getResource(int n, Random random) {
        return Item.sign.id;
    }

    @Override
    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.onGround) {
            if (!level.getMaterial(n, n2 - 1, n3).isSolid()) {
                bl = true;
            }
        } else {
            int n5 = level.getData(n, n2, n3);
            bl = true;
            if (n5 == 2 && level.getMaterial(n, n2, n3 + 1).isSolid()) {
                bl = false;
            }
            if (n5 == 3 && level.getMaterial(n, n2, n3 - 1).isSolid()) {
                bl = false;
            }
            if (n5 == 4 && level.getMaterial(n + 1, n2, n3).isSolid()) {
                bl = false;
            }
            if (n5 == 5 && level.getMaterial(n - 1, n2, n3).isSolid()) {
                bl = false;
            }
        }
        if (bl) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
        super.neighborChanged(level, n, n2, n3, n4);
    }
}

