/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.BasicTree;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.tile.Bush;

public class Sapling
extends Bush {
    protected Sapling(int n, int n2) {
        super(n, n2);
        float f = 0.4f;
        this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        super.tick(level, n, n2, n3, random);
        if (level.getRawBrightness(n, n2 + 1, n3) >= 9 && random.nextInt(5) == 0) {
            int n4 = level.getData(n, n2, n3);
            if (n4 < 15) {
                level.setData(n, n2, n3, n4 + 1);
            } else {
                this.growTree(level, n, n2, n3, random);
            }
        }
    }

    public void growTree(Level level, int n, int n2, int n3, Random random) {
        level.setTileNoUpdate(n, n2, n3, 0);
        Feature feature = new TreeFeature();
        if (random.nextInt(10) == 0) {
            feature = new BasicTree();
        }
        if (!((Feature)feature).place(level, random, n, n2, n3)) {
            level.setTileNoUpdate(n, n2, n3, this.id);
        }
    }
}

