/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.item.FallingTile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class SandTile
extends Tile {
    public static boolean instaFall = false;

    public SandTile(int n, int n2) {
        super(n, n2, Material.sand);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        level.addToTickNextTick(n, n2, n3, this.id);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        level.addToTickNextTick(n, n2, n3, this.id);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        this.checkSlide(level, n, n2, n3);
    }

    private void checkSlide(Level level, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        if (SandTile.isFree(level, n4, n5 - 1, n6) && n5 >= 0) {
            int n7 = 32;
            if (instaFall || !level.hasChunksAt(n - n7, n2 - n7, n3 - n7, n + n7, n2 + n7, n3 + n7)) {
                level.setTile(n, n2, n3, 0);
                while (SandTile.isFree(level, n, n2 - 1, n3) && n2 > 0) {
                    --n2;
                }
                if (n2 > 0) {
                    level.setTile(n, n2, n3, this.id);
                }
            } else {
                FallingTile fallingTile = new FallingTile(level, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, this.id);
                level.addEntity(fallingTile);
            }
        }
    }

    public int getTickDelay() {
        return 3;
    }

    public static boolean isFree(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3);
        if (n4 == 0) {
            return true;
        }
        if (n4 == Tile.fire.id) {
            return true;
        }
        Material material = Tile.tiles[n4].material;
        if (material == Material.water) {
            return true;
        }
        return material == Material.lava;
    }
}

