/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class ReedTile
extends Tile {
    protected ReedTile(int n, int n2) {
        super(n, Material.plant);
        this.tex = n2;
        float f = 0.375f;
        this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.setTicking(true);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.isEmptyTile(n, n2 + 1, n3)) {
            int n4 = 1;
            while (level.getTile(n, n2 - n4, n3) == this.id) {
                ++n4;
            }
            if (n4 < 3) {
                int n5 = level.getData(n, n2, n3);
                if (n5 == 15) {
                    level.setTile(n, n2 + 1, n3, this.id);
                    level.setData(n, n2, n3, 0);
                } else {
                    level.setData(n, n2, n3, n5 + 1);
                }
            }
        }
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2 - 1, n3);
        if (n4 == this.id) {
            return true;
        }
        if (n4 != Tile.grass.id && n4 != Tile.dirt.id) {
            return false;
        }
        if (level.getMaterial(n - 1, n2 - 1, n3) == Material.water) {
            return true;
        }
        if (level.getMaterial(n + 1, n2 - 1, n3) == Material.water) {
            return true;
        }
        if (level.getMaterial(n, n2 - 1, n3 - 1) == Material.water) {
            return true;
        }
        return level.getMaterial(n, n2 - 1, n3 + 1) == Material.water;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        this.checkAlive(level, n, n2, n3);
    }

    protected final void checkAlive(Level level, int n, int n2, int n3) {
        if (!this.canSurvive(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
    }

    public boolean canSurvive(Level level, int n, int n2, int n3) {
        return this.mayPlace(level, n, n2, n3);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public int getResource(int n, Random random) {
        return Item.reeds.id;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 1;
    }
}

