/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class RedStoneOreTile
extends Tile {
    private boolean lit;

    public RedStoneOreTile(int n, int n2, boolean bl) {
        super(n, n2, Material.stone);
        if (bl) {
            this.setTicking(true);
        }
        this.lit = bl;
    }

    public int getTickDelay() {
        return 30;
    }

    public void attack(Level level, int n, int n2, int n3, Player player) {
        this.interact(level, n, n2, n3);
        super.attack(level, n, n2, n3, player);
    }

    public void stepOn(Level level, int n, int n2, int n3, Entity entity) {
        this.interact(level, n, n2, n3);
        super.stepOn(level, n, n2, n3, entity);
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        this.interact(level, n, n2, n3);
        return super.use(level, n, n2, n3, player);
    }

    private void interact(Level level, int n, int n2, int n3) {
        this.poofParticles(level, n, n2, n3);
        if (this.id == Tile.redStoneOre.id) {
            level.setTile(n, n2, n3, Tile.redStoneOre_lit.id);
        }
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (this.id == Tile.redStoneOre_lit.id) {
            level.setTile(n, n2, n3, Tile.redStoneOre.id);
        }
    }

    public int getResource(int n, Random random) {
        return Item.redStone.id;
    }

    public int getResourceCount(Random random) {
        return 4 + random.nextInt(2);
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        if (this.lit) {
            this.poofParticles(level, n, n2, n3);
        }
    }

    private void poofParticles(Level level, int n, int n2, int n3) {
        Random random = level.random;
        double d = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d2 = (float)n + random.nextFloat();
            double d3 = (float)n2 + random.nextFloat();
            double d4 = (float)n3 + random.nextFloat();
            if (i == 0 && !level.isSolidTile(n, n2 + 1, n3)) {
                d3 = (double)(n2 + 1) + d;
            }
            if (i == 1 && !level.isSolidTile(n, n2 - 1, n3)) {
                d3 = (double)(n2 + 0) - d;
            }
            if (i == 2 && !level.isSolidTile(n, n2, n3 + 1)) {
                d4 = (double)(n3 + 1) + d;
            }
            if (i == 3 && !level.isSolidTile(n, n2, n3 - 1)) {
                d4 = (double)(n3 + 0) - d;
            }
            if (i == 4 && !level.isSolidTile(n + 1, n2, n3)) {
                d2 = (double)(n + 1) + d;
            }
            if (i == 5 && !level.isSolidTile(n - 1, n2, n3)) {
                d2 = (double)(n + 0) - d;
            }
            if (!(d2 < (double)n || d2 > (double)(n + 1) || d3 < 0.0 || d3 > (double)(n2 + 1) || d4 < (double)n3) && !(d4 > (double)(n3 + 1))) continue;
            level.addParticle("reddust", d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }
}

