/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.TilePos;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class RedStoneDustTile
extends Tile {
    private boolean shouldSignal = true;
    private Set<TilePos> toUpdate = new HashSet<TilePos>();

    public RedStoneDustTile(int n, int n2) {
        super(n, n2, Material.decoration);
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    public int getTexture(int n, int n2) {
        return this.tex + (n2 > 0 ? 16 : 0);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 5;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        return level.isSolidTile(n, n2 - 1, n3);
    }

    private void updatePowerStrength(Level level, int n, int n2, int n3) {
        this.updatePowerStrength(level, n, n2, n3, n, n2, n3);
        ArrayList<TilePos> arrayList = new ArrayList<TilePos>(this.toUpdate);
        this.toUpdate.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            TilePos tilePos = (TilePos)arrayList.get(i);
            level.updateNeighborsAt(tilePos.x, tilePos.y, tilePos.z, this.id);
        }
    }

    private void updatePowerStrength(Level level, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10 = level.getData(n, n2, n3);
        int n11 = 0;
        this.shouldSignal = false;
        boolean bl = level.hasNeighborSignal(n, n2, n3);
        this.shouldSignal = true;
        if (bl) {
            n11 = 15;
        } else {
            for (n9 = 0; n9 < 4; ++n9) {
                n8 = n;
                n7 = n3;
                if (n9 == 0) {
                    --n8;
                }
                if (n9 == 1) {
                    ++n8;
                }
                if (n9 == 2) {
                    --n7;
                }
                if (n9 == 3) {
                    ++n7;
                }
                if (n8 != n4 || n2 != n5 || n7 != n6) {
                    n11 = this.checkTarget(level, n8, n2, n7, n11);
                }
                if (level.isSolidTile(n8, n2, n7) && !level.isSolidTile(n, n2 + 1, n3)) {
                    if (n8 == n4 && n2 + 1 == n5 && n7 == n6) continue;
                    n11 = this.checkTarget(level, n8, n2 + 1, n7, n11);
                    continue;
                }
                if (level.isSolidTile(n8, n2, n7) || n8 == n4 && n2 - 1 == n5 && n7 == n6) continue;
                n11 = this.checkTarget(level, n8, n2 - 1, n7, n11);
            }
            n11 = n11 > 0 ? --n11 : 0;
        }
        if (n10 != n11) {
            level.noNeighborUpdate = true;
            level.setData(n, n2, n3, n11);
            level.setTilesDirty(n, n2, n3, n, n2, n3);
            level.noNeighborUpdate = false;
            for (n9 = 0; n9 < 4; ++n9) {
                n8 = n;
                n7 = n3;
                int n12 = n2 - 1;
                if (n9 == 0) {
                    --n8;
                }
                if (n9 == 1) {
                    ++n8;
                }
                if (n9 == 2) {
                    --n7;
                }
                if (n9 == 3) {
                    ++n7;
                }
                if (level.isSolidTile(n8, n2, n7)) {
                    n12 += 2;
                }
                int n13 = 0;
                n13 = this.checkTarget(level, n8, n2, n7, -1);
                n11 = level.getData(n, n2, n3);
                if (n11 > 0) {
                    --n11;
                }
                if (n13 >= 0 && n13 != n11) {
                    this.updatePowerStrength(level, n8, n2, n7, n, n2, n3);
                }
                n13 = this.checkTarget(level, n8, n12, n7, -1);
                n11 = level.getData(n, n2, n3);
                if (n11 > 0) {
                    --n11;
                }
                if (n13 < 0 || n13 == n11) continue;
                this.updatePowerStrength(level, n8, n12, n7, n, n2, n3);
            }
            if (n10 == 0 || n11 == 0) {
                this.toUpdate.add(new TilePos(n, n2, n3));
                this.toUpdate.add(new TilePos(n - 1, n2, n3));
                this.toUpdate.add(new TilePos(n + 1, n2, n3));
                this.toUpdate.add(new TilePos(n, n2 - 1, n3));
                this.toUpdate.add(new TilePos(n, n2 + 1, n3));
                this.toUpdate.add(new TilePos(n, n2, n3 - 1));
                this.toUpdate.add(new TilePos(n, n2, n3 + 1));
            }
        }
    }

    private void checkCornerChangeAt(Level level, int n, int n2, int n3) {
        if (level.getTile(n, n2, n3) != this.id) {
            return;
        }
        level.updateNeighborsAt(n, n2, n3, this.id);
        level.updateNeighborsAt(n - 1, n2, n3, this.id);
        level.updateNeighborsAt(n + 1, n2, n3, this.id);
        level.updateNeighborsAt(n, n2, n3 - 1, this.id);
        level.updateNeighborsAt(n, n2, n3 + 1, this.id);
        level.updateNeighborsAt(n, n2 - 1, n3, this.id);
        level.updateNeighborsAt(n, n2 + 1, n3, this.id);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        super.onPlace(level, n, n2, n3);
        if (level.isOnline) {
            return;
        }
        this.updatePowerStrength(level, n, n2, n3);
        level.updateNeighborsAt(n, n2 + 1, n3, this.id);
        level.updateNeighborsAt(n, n2 - 1, n3, this.id);
        this.checkCornerChangeAt(level, n - 1, n2, n3);
        this.checkCornerChangeAt(level, n + 1, n2, n3);
        this.checkCornerChangeAt(level, n, n2, n3 - 1);
        this.checkCornerChangeAt(level, n, n2, n3 + 1);
        if (level.isSolidTile(n - 1, n2, n3)) {
            this.checkCornerChangeAt(level, n - 1, n2 + 1, n3);
        } else {
            this.checkCornerChangeAt(level, n - 1, n2 - 1, n3);
        }
        if (level.isSolidTile(n + 1, n2, n3)) {
            this.checkCornerChangeAt(level, n + 1, n2 + 1, n3);
        } else {
            this.checkCornerChangeAt(level, n + 1, n2 - 1, n3);
        }
        if (level.isSolidTile(n, n2, n3 - 1)) {
            this.checkCornerChangeAt(level, n, n2 + 1, n3 - 1);
        } else {
            this.checkCornerChangeAt(level, n, n2 - 1, n3 - 1);
        }
        if (level.isSolidTile(n, n2, n3 + 1)) {
            this.checkCornerChangeAt(level, n, n2 + 1, n3 + 1);
        } else {
            this.checkCornerChangeAt(level, n, n2 - 1, n3 + 1);
        }
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        super.onRemove(level, n, n2, n3);
        if (level.isOnline) {
            return;
        }
        level.updateNeighborsAt(n, n2 + 1, n3, this.id);
        level.updateNeighborsAt(n, n2 - 1, n3, this.id);
        this.updatePowerStrength(level, n, n2, n3);
        this.checkCornerChangeAt(level, n - 1, n2, n3);
        this.checkCornerChangeAt(level, n + 1, n2, n3);
        this.checkCornerChangeAt(level, n, n2, n3 - 1);
        this.checkCornerChangeAt(level, n, n2, n3 + 1);
        if (level.isSolidTile(n - 1, n2, n3)) {
            this.checkCornerChangeAt(level, n - 1, n2 + 1, n3);
        } else {
            this.checkCornerChangeAt(level, n - 1, n2 - 1, n3);
        }
        if (level.isSolidTile(n + 1, n2, n3)) {
            this.checkCornerChangeAt(level, n + 1, n2 + 1, n3);
        } else {
            this.checkCornerChangeAt(level, n + 1, n2 - 1, n3);
        }
        if (level.isSolidTile(n, n2, n3 - 1)) {
            this.checkCornerChangeAt(level, n, n2 + 1, n3 - 1);
        } else {
            this.checkCornerChangeAt(level, n, n2 - 1, n3 - 1);
        }
        if (level.isSolidTile(n, n2, n3 + 1)) {
            this.checkCornerChangeAt(level, n, n2 + 1, n3 + 1);
        } else {
            this.checkCornerChangeAt(level, n, n2 - 1, n3 + 1);
        }
    }

    private int checkTarget(Level level, int n, int n2, int n3, int n4) {
        if (level.getTile(n, n2, n3) != this.id) {
            return n4;
        }
        int n5 = level.getData(n, n2, n3);
        if (n5 > n4) {
            return n5;
        }
        return n4;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (level.isOnline) {
            return;
        }
        int n5 = level.getData(n, n2, n3);
        boolean bl = this.mayPlace(level, n, n2, n3);
        if (!bl) {
            this.spawnResources(level, n, n2, n3, n5);
            level.setTile(n, n2, n3, 0);
        } else {
            this.updatePowerStrength(level, n, n2, n3);
        }
        super.neighborChanged(level, n, n2, n3, n4);
    }

    public int getResource(int n, Random random) {
        return Item.redStone.id;
    }

    public boolean getDirectSignal(Level level, int n, int n2, int n3, int n4) {
        if (!this.shouldSignal) {
            return false;
        }
        return this.getSignal(level, n, n2, n3, n4);
    }

    public boolean getSignal(LevelSource levelSource, int n, int n2, int n3, int n4) {
        boolean bl;
        if (!this.shouldSignal) {
            return false;
        }
        if (levelSource.getData(n, n2, n3) == 0) {
            return false;
        }
        if (n4 == 1) {
            return true;
        }
        boolean bl2 = RedStoneDustTile.shouldConnectTo(levelSource, n - 1, n2, n3) || !levelSource.isSolidTile(n - 1, n2, n3) && RedStoneDustTile.shouldConnectTo(levelSource, n - 1, n2 - 1, n3);
        boolean bl3 = RedStoneDustTile.shouldConnectTo(levelSource, n + 1, n2, n3) || !levelSource.isSolidTile(n + 1, n2, n3) && RedStoneDustTile.shouldConnectTo(levelSource, n + 1, n2 - 1, n3);
        boolean bl4 = RedStoneDustTile.shouldConnectTo(levelSource, n, n2, n3 - 1) || !levelSource.isSolidTile(n, n2, n3 - 1) && RedStoneDustTile.shouldConnectTo(levelSource, n, n2 - 1, n3 - 1);
        boolean bl5 = bl = RedStoneDustTile.shouldConnectTo(levelSource, n, n2, n3 + 1) || !levelSource.isSolidTile(n, n2, n3 + 1) && RedStoneDustTile.shouldConnectTo(levelSource, n, n2 - 1, n3 + 1);
        if (!levelSource.isSolidTile(n, n2 + 1, n3)) {
            if (levelSource.isSolidTile(n - 1, n2, n3) && RedStoneDustTile.shouldConnectTo(levelSource, n - 1, n2 + 1, n3)) {
                bl2 = true;
            }
            if (levelSource.isSolidTile(n + 1, n2, n3) && RedStoneDustTile.shouldConnectTo(levelSource, n + 1, n2 + 1, n3)) {
                bl3 = true;
            }
            if (levelSource.isSolidTile(n, n2, n3 - 1) && RedStoneDustTile.shouldConnectTo(levelSource, n, n2 + 1, n3 - 1)) {
                bl4 = true;
            }
            if (levelSource.isSolidTile(n, n2, n3 + 1) && RedStoneDustTile.shouldConnectTo(levelSource, n, n2 + 1, n3 + 1)) {
                bl = true;
            }
        }
        if (!(bl4 || bl3 || bl2 || bl || n4 < 2 || n4 > 5)) {
            return true;
        }
        if (n4 == 2 && bl4 && !bl2 && !bl3) {
            return true;
        }
        if (n4 == 3 && bl && !bl2 && !bl3) {
            return true;
        }
        if (n4 == 4 && bl2 && !bl4 && !bl) {
            return true;
        }
        return n4 == 5 && bl3 && !bl4 && !bl;
    }

    public boolean isSignalSource() {
        return this.shouldSignal;
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        if (level.getData(n, n2, n3) > 0) {
            double d = (double)n + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d2 = (float)n2 + 0.0625f;
            double d3 = (double)n3 + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            level.addParticle("reddust", d, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    public static boolean shouldConnectTo(LevelSource levelSource, int n, int n2, int n3) {
        int n4 = levelSource.getTile(n, n2, n3);
        if (n4 == Tile.redStoneDust.id) {
            return true;
        }
        if (n4 == 0) {
            return false;
        }
        return Tile.tiles[n4].isSignalSource();
    }
}

