/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class RecordPlayerTile
extends Tile {
    protected RecordPlayerTile(int n, int n2) {
        super(n, n2, Material.wood);
    }

    public int getTexture(int n) {
        return this.tex + (n == 1 ? 1 : 0);
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        int n4 = level.getData(n, n2, n3);
        if (n4 > 0) {
            this.dropRecording(level, n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public void dropRecording(Level level, int n, int n2, int n3, int n4) {
        level.playStreamingMusic(null, n, n2, n3);
        level.setData(n, n2, n3, 0);
        int n5 = Item.record_01.id + n4 - 1;
        float f = 0.7f;
        double d = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
        double d3 = (double)(level.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ItemEntity itemEntity = new ItemEntity(level, (double)n + d, (double)n2 + d2, (double)n3 + d3, new ItemInstance(n5, 1, 0));
        itemEntity.throwTime = 10;
        level.addEntity(itemEntity);
    }

    public void spawnResources(Level level, int n, int n2, int n3, int n4, float f) {
        if (level.isOnline) {
            return;
        }
        if (n4 > 0) {
            this.dropRecording(level, n, n2, n3, n4);
        }
        super.spawnResources(level, n, n2, n3, n4, f);
    }
}

