/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.TilePos;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RailTile
extends Tile {
    protected RailTile(int n, int n2) {
        super(n, n2, Material.decoration);
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public HitResult clip(Level level, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.updateShape(level, n, n2, n3);
        return super.clip(level, n, n2, n3, vec3, vec32);
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        int n4 = levelSource.getData(n, n2, n3);
        if (n4 >= 2 && n4 <= 5) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public int getTexture(int n, int n2) {
        if (n2 >= 6) {
            return this.tex - 16;
        }
        return this.tex;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 9;
    }

    public int getResourceCount(Random random) {
        return 1;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        return level.isSolidTile(n, n2 - 1, n3);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        if (!level.isOnline) {
            level.setData(n, n2, n3, 15);
            this.updateDir(level, n, n2, n3);
        }
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (level.isOnline) {
            return;
        }
        int n5 = level.getData(n, n2, n3);
        boolean bl = false;
        if (!level.isSolidTile(n, n2 - 1, n3)) {
            bl = true;
        }
        if (n5 == 2 && !level.isSolidTile(n + 1, n2, n3)) {
            bl = true;
        }
        if (n5 == 3 && !level.isSolidTile(n - 1, n2, n3)) {
            bl = true;
        }
        if (n5 == 4 && !level.isSolidTile(n, n2, n3 - 1)) {
            bl = true;
        }
        if (n5 == 5 && !level.isSolidTile(n, n2, n3 + 1)) {
            bl = true;
        }
        if (bl) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        } else if (n4 > 0 && Tile.tiles[n4].isSignalSource() && new Rail(level, n, n2, n3).countPotentialConnections() == 3) {
            this.updateDir(level, n, n2, n3);
        }
    }

    private void updateDir(Level level, int n, int n2, int n3) {
        if (level.isOnline) {
            return;
        }
        new Rail(level, n, n2, n3).place(level.hasNeighborSignal(n, n2, n3));
    }

    private class Rail {
        private Level level;
        private int x;
        private int y;
        private int z;
        private int data;
        private List<TilePos> connections = new ArrayList<TilePos>();

        public Rail(Level level, int n, int n2, int n3) {
            this.level = level;
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.data = level.getData(n, n2, n3);
            this.updateConnections();
        }

        private void updateConnections() {
            this.connections.clear();
            if (this.data == 0) {
                this.connections.add(new TilePos(this.x, this.y, this.z - 1));
                this.connections.add(new TilePos(this.x, this.y, this.z + 1));
            } else if (this.data == 1) {
                this.connections.add(new TilePos(this.x - 1, this.y, this.z));
                this.connections.add(new TilePos(this.x + 1, this.y, this.z));
            } else if (this.data == 2) {
                this.connections.add(new TilePos(this.x - 1, this.y, this.z));
                this.connections.add(new TilePos(this.x + 1, this.y + 1, this.z));
            } else if (this.data == 3) {
                this.connections.add(new TilePos(this.x - 1, this.y + 1, this.z));
                this.connections.add(new TilePos(this.x + 1, this.y, this.z));
            } else if (this.data == 4) {
                this.connections.add(new TilePos(this.x, this.y + 1, this.z - 1));
                this.connections.add(new TilePos(this.x, this.y, this.z + 1));
            } else if (this.data == 5) {
                this.connections.add(new TilePos(this.x, this.y, this.z - 1));
                this.connections.add(new TilePos(this.x, this.y + 1, this.z + 1));
            } else if (this.data == 6) {
                this.connections.add(new TilePos(this.x + 1, this.y, this.z));
                this.connections.add(new TilePos(this.x, this.y, this.z + 1));
            } else if (this.data == 7) {
                this.connections.add(new TilePos(this.x - 1, this.y, this.z));
                this.connections.add(new TilePos(this.x, this.y, this.z + 1));
            } else if (this.data == 8) {
                this.connections.add(new TilePos(this.x - 1, this.y, this.z));
                this.connections.add(new TilePos(this.x, this.y, this.z - 1));
            } else if (this.data == 9) {
                this.connections.add(new TilePos(this.x + 1, this.y, this.z));
                this.connections.add(new TilePos(this.x, this.y, this.z - 1));
            }
        }

        private void removeSoftConnections() {
            for (int i = 0; i < this.connections.size(); ++i) {
                Rail rail = this.getRail(this.connections.get(i));
                if (rail == null || !rail.connectsTo(this)) {
                    this.connections.remove(i--);
                    continue;
                }
                this.connections.set(i, new TilePos(rail.x, rail.y, rail.z));
            }
        }

        private boolean hasRail(int n, int n2, int n3) {
            if (this.level.getTile(n, n2, n3) == RailTile.this.id) {
                return true;
            }
            if (this.level.getTile(n, n2 + 1, n3) == RailTile.this.id) {
                return true;
            }
            return this.level.getTile(n, n2 - 1, n3) == RailTile.this.id;
        }

        private Rail getRail(TilePos tilePos) {
            if (this.level.getTile(tilePos.x, tilePos.y, tilePos.z) == RailTile.this.id) {
                return new Rail(this.level, tilePos.x, tilePos.y, tilePos.z);
            }
            if (this.level.getTile(tilePos.x, tilePos.y + 1, tilePos.z) == RailTile.this.id) {
                return new Rail(this.level, tilePos.x, tilePos.y + 1, tilePos.z);
            }
            if (this.level.getTile(tilePos.x, tilePos.y - 1, tilePos.z) == RailTile.this.id) {
                return new Rail(this.level, tilePos.x, tilePos.y - 1, tilePos.z);
            }
            return null;
        }

        private boolean connectsTo(Rail rail) {
            for (int i = 0; i < this.connections.size(); ++i) {
                TilePos tilePos = this.connections.get(i);
                if (tilePos.x != rail.x || tilePos.z != rail.z) continue;
                return true;
            }
            return false;
        }

        private boolean hasConnection(int n, int n2, int n3) {
            for (int i = 0; i < this.connections.size(); ++i) {
                TilePos tilePos = this.connections.get(i);
                if (tilePos.x != n || tilePos.z != n3) continue;
                return true;
            }
            return false;
        }

        private int countPotentialConnections() {
            int n = 0;
            if (this.hasRail(this.x, this.y, this.z - 1)) {
                ++n;
            }
            if (this.hasRail(this.x, this.y, this.z + 1)) {
                ++n;
            }
            if (this.hasRail(this.x - 1, this.y, this.z)) {
                ++n;
            }
            if (this.hasRail(this.x + 1, this.y, this.z)) {
                ++n;
            }
            return n;
        }

        private boolean canConnectTo(Rail rail) {
            if (this.connectsTo(rail)) {
                return true;
            }
            if (this.connections.size() == 2) {
                return false;
            }
            if (this.connections.size() == 0) {
                return true;
            }
            TilePos tilePos = this.connections.get(0);
            if (rail.y == this.y && tilePos.y == this.y) {
                return true;
            }
            return true;
        }

        private void connectTo(Rail rail) {
            this.connections.add(new TilePos(rail.x, rail.y, rail.z));
            boolean bl = this.hasConnection(this.x, this.y, this.z - 1);
            boolean bl2 = this.hasConnection(this.x, this.y, this.z + 1);
            boolean bl3 = this.hasConnection(this.x - 1, this.y, this.z);
            boolean bl4 = this.hasConnection(this.x + 1, this.y, this.z);
            int n = -1;
            if (bl || bl2) {
                n = 0;
            }
            if (bl3 || bl4) {
                n = 1;
            }
            if (bl2 && bl4 && !bl && !bl3) {
                n = 6;
            }
            if (bl2 && bl3 && !bl && !bl4) {
                n = 7;
            }
            if (bl && bl3 && !bl2 && !bl4) {
                n = 8;
            }
            if (bl && bl4 && !bl2 && !bl3) {
                n = 9;
            }
            if (n == 0) {
                if (this.level.getTile(this.x, this.y + 1, this.z - 1) == RailTile.this.id) {
                    n = 4;
                }
                if (this.level.getTile(this.x, this.y + 1, this.z + 1) == RailTile.this.id) {
                    n = 5;
                }
            }
            if (n == 1) {
                if (this.level.getTile(this.x + 1, this.y + 1, this.z) == RailTile.this.id) {
                    n = 2;
                }
                if (this.level.getTile(this.x - 1, this.y + 1, this.z) == RailTile.this.id) {
                    n = 3;
                }
            }
            if (n < 0) {
                n = 0;
            }
            this.level.setData(this.x, this.y, this.z, n);
        }

        private boolean hasNeighborRail(int n, int n2, int n3) {
            Rail rail = this.getRail(new TilePos(n, n2, n3));
            if (rail == null) {
                return false;
            }
            rail.removeSoftConnections();
            return rail.canConnectTo(this);
        }

        public void place(boolean bl) {
            boolean bl2 = this.hasNeighborRail(this.x, this.y, this.z - 1);
            boolean bl3 = this.hasNeighborRail(this.x, this.y, this.z + 1);
            boolean bl4 = this.hasNeighborRail(this.x - 1, this.y, this.z);
            boolean bl5 = this.hasNeighborRail(this.x + 1, this.y, this.z);
            int n = -1;
            if ((bl2 || bl3) && !bl4 && !bl5) {
                n = 0;
            }
            if ((bl4 || bl5) && !bl2 && !bl3) {
                n = 1;
            }
            if (bl3 && bl5 && !bl2 && !bl4) {
                n = 6;
            }
            if (bl3 && bl4 && !bl2 && !bl5) {
                n = 7;
            }
            if (bl2 && bl4 && !bl3 && !bl5) {
                n = 8;
            }
            if (bl2 && bl5 && !bl3 && !bl4) {
                n = 9;
            }
            if (n == -1) {
                if (bl2 || bl3) {
                    n = 0;
                }
                if (bl4 || bl5) {
                    n = 1;
                }
                if (bl) {
                    if (bl3 && bl5) {
                        n = 6;
                    }
                    if (bl4 && bl3) {
                        n = 7;
                    }
                    if (bl5 && bl2) {
                        n = 9;
                    }
                    if (bl2 && bl4) {
                        n = 8;
                    }
                } else {
                    if (bl2 && bl4) {
                        n = 8;
                    }
                    if (bl5 && bl2) {
                        n = 9;
                    }
                    if (bl4 && bl3) {
                        n = 7;
                    }
                    if (bl3 && bl5) {
                        n = 6;
                    }
                }
            }
            if (n == 0) {
                if (this.level.getTile(this.x, this.y + 1, this.z - 1) == RailTile.this.id) {
                    n = 4;
                }
                if (this.level.getTile(this.x, this.y + 1, this.z + 1) == RailTile.this.id) {
                    n = 5;
                }
            }
            if (n == 1) {
                if (this.level.getTile(this.x + 1, this.y + 1, this.z) == RailTile.this.id) {
                    n = 2;
                }
                if (this.level.getTile(this.x - 1, this.y + 1, this.z) == RailTile.this.id) {
                    n = 3;
                }
            }
            if (n < 0) {
                n = 0;
            }
            this.data = n;
            this.updateConnections();
            this.level.setData(this.x, this.y, this.z, n);
            for (int i = 0; i < this.connections.size(); ++i) {
                Rail rail = this.getRail(this.connections.get(i));
                if (rail == null) continue;
                rail.removeSoftConnections();
                if (!rail.canConnectTo(this)) continue;
                rail.connectTo(this);
            }
        }
    }
}

