/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import util.Mth;

public class PumpkinTile
extends Tile {
    private boolean lit;

    protected PumpkinTile(int n, int n2, boolean bl) {
        super(n, Material.vegetable);
        this.tex = n2;
        this.setTicking(true);
        this.lit = bl;
    }

    public int getTexture(int n, int n2) {
        if (n == 1) {
            return this.tex;
        }
        if (n == 0) {
            return this.tex;
        }
        int n3 = this.tex + 1 + 16;
        if (this.lit) {
            ++n3;
        }
        if (n2 == 0 && n == 2) {
            return n3;
        }
        if (n2 == 1 && n == 5) {
            return n3;
        }
        if (n2 == 2 && n == 3) {
            return n3;
        }
        if (n2 == 3 && n == 4) {
            return n3;
        }
        return this.tex + 16;
    }

    public int getTexture(int n) {
        if (n == 1) {
            return this.tex;
        }
        if (n == 0) {
            return this.tex;
        }
        if (n == 3) {
            return this.tex + 1 + 16;
        }
        return this.tex + 16;
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        super.onPlace(level, n, n2, n3);
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3);
        return (n4 == 0 || Tile.tiles[n4].material.isLiquid()) && level.isSolidTile(n, n2 - 1, n3);
    }

    public void setPlacedBy(Level level, int n, int n2, int n3, Mob mob) {
        int n4 = Mth.floor((double)(mob.yRot * 4.0f / 360.0f) + 0.5) & 3;
        level.setData(n, n2, n3, n4);
    }
}

