/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class PressurePlateTile
extends Tile {
    private Sensitivity sensitivity;

    protected PressurePlateTile(int n, int n2, Sensitivity sensitivity) {
        super(n, n2, Material.stone);
        this.sensitivity = sensitivity;
        this.setTicking(true);
        float f = 0.0625f;
        this.setShape(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
    }

    public int getTickDelay() {
        return 20;
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        return level.isSolidTile(n, n2 - 1, n3);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (!level.isSolidTile(n, n2 - 1, n3)) {
            bl = true;
        }
        if (bl) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.isOnline) {
            return;
        }
        if (level.getData(n, n2, n3) == 0) {
            return;
        }
        this.checkPressed(level, n, n2, n3);
    }

    public void entityInside(Level level, int n, int n2, int n3, Entity entity) {
        if (level.isOnline) {
            return;
        }
        if (level.getData(n, n2, n3) == 1) {
            return;
        }
        this.checkPressed(level, n, n2, n3);
    }

    private void checkPressed(Level level, int n, int n2, int n3) {
        boolean bl = level.getData(n, n2, n3) == 1;
        boolean bl2 = false;
        float f = 0.125f;
        List<Entity> list = null;
        if (this.sensitivity == Sensitivity.everything) {
            list = level.getEntities(null, AABB.newTemp((float)n + f, n2, (float)n3 + f, (float)(n + 1) - f, (double)n2 + 0.25, (float)(n3 + 1) - f));
        }
        if (this.sensitivity == Sensitivity.mobs) {
            list = level.getEntitiesOfClass(Mob.class, AABB.newTemp((float)n + f, n2, (float)n3 + f, (float)(n + 1) - f, (double)n2 + 0.25, (float)(n3 + 1) - f));
        }
        if (this.sensitivity == Sensitivity.players) {
            list = level.getEntitiesOfClass(Player.class, AABB.newTemp((float)n + f, n2, (float)n3 + f, (float)(n + 1) - f, (double)n2 + 0.25, (float)(n3 + 1) - f));
        }
        if (list.size() > 0) {
            bl2 = true;
        }
        if (bl2 && !bl) {
            level.setData(n, n2, n3, 1);
            level.updateNeighborsAt(n, n2, n3, this.id);
            level.updateNeighborsAt(n, n2 - 1, n3, this.id);
            level.setTilesDirty(n, n2, n3, n, n2, n3);
            level.playSound((double)n + 0.5, (double)n2 + 0.1, (double)n3 + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!bl2 && bl) {
            level.setData(n, n2, n3, 0);
            level.updateNeighborsAt(n, n2, n3, this.id);
            level.updateNeighborsAt(n, n2 - 1, n3, this.id);
            level.setTilesDirty(n, n2, n3, n, n2, n3);
            level.playSound((double)n + 0.5, (double)n2 + 0.1, (double)n3 + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (bl2) {
            level.addToTickNextTick(n, n2, n3, this.id);
        }
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        if (n4 > 0) {
            level.updateNeighborsAt(n, n2, n3, this.id);
            level.updateNeighborsAt(n, n2 - 1, n3, this.id);
        }
        super.onRemove(level, n, n2, n3);
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        boolean bl = levelSource.getData(n, n2, n3) == 1;
        float f = 0.0625f;
        if (bl) {
            this.setShape(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
        } else {
            this.setShape(f, 0.0f, f, 1.0f - f, 0.0625f, 1.0f - f);
        }
    }

    public boolean getSignal(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return levelSource.getData(n, n2, n3) > 0;
    }

    public boolean getDirectSignal(Level level, int n, int n2, int n3, int n4) {
        if (level.getData(n, n2, n3) == 0) {
            return false;
        }
        return n4 == 1;
    }

    public boolean isSignalSource() {
        return true;
    }

    public void updateDefaultShape() {
        float f = 0.5f;
        float f2 = 0.125f;
        float f3 = 0.5f;
        this.setShape(0.5f - f, 0.5f - f2, 0.5f - f3, 0.5f + f, 0.5f + f2, 0.5f + f3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sensitivity {
        everything,
        mobs,
        players;

    }
}

