/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.HalfTransparentTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class PortalTile
extends HalfTransparentTile {
    public PortalTile(int n, int n2) {
        super(n, n2, Material.portal, false);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        if (levelSource.getTile(n - 1, n2, n3) == this.id || levelSource.getTile(n + 1, n2, n3) == this.id) {
            float f = 0.5f;
            float f2 = 0.125f;
            this.setShape(0.5f - f, 0.0f, 0.5f - f2, 0.5f + f, 1.0f, 0.5f + f2);
        } else {
            float f = 0.125f;
            float f3 = 0.5f;
            this.setShape(0.5f - f, 0.0f, 0.5f - f3, 0.5f + f, 1.0f, 0.5f + f3);
        }
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean trySpawnPortal(Level level, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        if (level.getTile(n - 1, n2, n3) == Tile.obsidian.id || level.getTile(n + 1, n2, n3) == Tile.obsidian.id) {
            n6 = 1;
        }
        if (level.getTile(n, n2, n3 - 1) == Tile.obsidian.id || level.getTile(n, n2, n3 + 1) == Tile.obsidian.id) {
            n7 = 1;
        }
        System.out.println(n6 + ", " + n7);
        if (n6 == n7) {
            return false;
        }
        if (level.getTile(n - n6, n2, n3 - n7) == 0) {
            n -= n6;
            n3 -= n7;
        }
        for (n5 = -1; n5 <= 2; ++n5) {
            for (n4 = -1; n4 <= 3; ++n4) {
                boolean bl;
                boolean bl2 = bl = n5 == -1 || n5 == 2 || n4 == -1 || n4 == 3;
                if (!(n5 != -1 && n5 != 2 || n4 != -1 && n4 != 3)) continue;
                int n8 = level.getTile(n + n6 * n5, n2 + n4, n3 + n7 * n5);
                if (!(bl ? n8 != Tile.obsidian.id : n8 != 0 && n8 != Tile.fire.id)) continue;
                return false;
            }
        }
        level.noNeighborUpdate = true;
        for (n5 = 0; n5 < 2; ++n5) {
            for (n4 = 0; n4 < 3; ++n4) {
                level.setTile(n + n6 * n5, n2 + n4, n3 + n7 * n5, Tile.portalTile.id);
            }
        }
        level.noNeighborUpdate = false;
        return true;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5;
        int n6 = 0;
        int n7 = 1;
        if (level.getTile(n - 1, n2, n3) == this.id || level.getTile(n + 1, n2, n3) == this.id) {
            n6 = 1;
            n7 = 0;
        }
        int n8 = n2;
        while (level.getTile(n, n8 - 1, n3) == this.id) {
            --n8;
        }
        if (level.getTile(n, n8 - 1, n3) != Tile.obsidian.id) {
            level.setTile(n, n2, n3, 0);
            return;
        }
        for (n5 = 1; n5 < 4 && level.getTile(n, n8 + n5, n3) == this.id; ++n5) {
        }
        if (n5 != 3 || level.getTile(n, n8 + n5, n3) != Tile.obsidian.id) {
            level.setTile(n, n2, n3, 0);
            return;
        }
        boolean bl2 = level.getTile(n - 1, n2, n3) == this.id || level.getTile(n + 1, n2, n3) == this.id;
        boolean bl3 = bl = level.getTile(n, n2, n3 - 1) == this.id || level.getTile(n, n2, n3 + 1) == this.id;
        if (bl2 && bl) {
            level.setTile(n, n2, n3, 0);
            return;
        }
        if (!(level.getTile(n + n6, n2, n3 + n7) == Tile.obsidian.id && level.getTile(n - n6, n2, n3 - n7) == this.id || level.getTile(n - n6, n2, n3 - n7) == Tile.obsidian.id && level.getTile(n + n6, n2, n3 + n7) == this.id)) {
            level.setTile(n, n2, n3, 0);
            return;
        }
    }

    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return true;
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    public int getRenderLayer() {
        return 1;
    }

    public void entityInside(Level level, int n, int n2, int n3, Entity entity) {
        if (level.isOnline) {
            return;
        }
        entity.handleInsidePortal();
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        if (random.nextInt(100) == 0) {
            level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "portal.portal", 1.0f, random.nextFloat() * 0.4f + 0.8f);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (float)n + random.nextFloat();
            double d2 = (float)n2 + random.nextFloat();
            double d3 = (float)n3 + random.nextFloat();
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n4 = random.nextInt(2) * 2 - 1;
            d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            d6 = ((double)random.nextFloat() - 0.5) * 0.5;
            if (level.getTile(n - 1, n2, n3) == this.id || level.getTile(n + 1, n2, n3) == this.id) {
                d3 = (double)n3 + 0.5 + 0.25 * (double)n4;
                d6 = random.nextFloat() * 2.0f * (float)n4;
            } else {
                d = (double)n + 0.5 + 0.25 * (double)n4;
                d4 = random.nextFloat() * 2.0f * (float)n4;
            }
            level.addParticle("portal", d, d2, d3, d4, d5, d6);
        }
    }
}

