/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.TorchTile;

public class NotGateTile
extends TorchTile {
    private static final int RECENT_TOGGLE_TIMER = 100;
    private static final int MAX_RECENT_TOGGLES = 8;
    private boolean on = false;
    private static List<Toggle> recentToggles = new ArrayList<Toggle>();

    public int getTexture(int n, int n2) {
        if (n == 1) {
            return Tile.redStoneDust.getTexture(n, n2);
        }
        return super.getTexture(n, n2);
    }

    private boolean isToggledTooFrequently(Level level, int n, int n2, int n3, boolean bl) {
        if (bl) {
            recentToggles.add(new Toggle(n, n2, n3, level.time));
        }
        int n4 = 0;
        for (int i = 0; i < recentToggles.size(); ++i) {
            Toggle toggle = recentToggles.get(i);
            if (toggle.x != n || toggle.y != n2 || toggle.z != n3 || ++n4 < 8) continue;
            return true;
        }
        return false;
    }

    protected NotGateTile(int n, int n2, boolean bl) {
        super(n, n2);
        this.on = bl;
        this.setTicking(true);
    }

    public int getTickDelay() {
        return 2;
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        if (level.getData(n, n2, n3) == 0) {
            super.onPlace(level, n, n2, n3);
        }
        if (this.on) {
            level.updateNeighborsAt(n, n2 - 1, n3, this.id);
            level.updateNeighborsAt(n, n2 + 1, n3, this.id);
            level.updateNeighborsAt(n - 1, n2, n3, this.id);
            level.updateNeighborsAt(n + 1, n2, n3, this.id);
            level.updateNeighborsAt(n, n2, n3 - 1, this.id);
            level.updateNeighborsAt(n, n2, n3 + 1, this.id);
        }
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        if (this.on) {
            level.updateNeighborsAt(n, n2 - 1, n3, this.id);
            level.updateNeighborsAt(n, n2 + 1, n3, this.id);
            level.updateNeighborsAt(n - 1, n2, n3, this.id);
            level.updateNeighborsAt(n + 1, n2, n3, this.id);
            level.updateNeighborsAt(n, n2, n3 - 1, this.id);
            level.updateNeighborsAt(n, n2, n3 + 1, this.id);
        }
    }

    public boolean getSignal(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (!this.on) {
            return false;
        }
        int n5 = levelSource.getData(n, n2, n3);
        if (n5 == 5 && n4 == 1) {
            return false;
        }
        if (n5 == 3 && n4 == 3) {
            return false;
        }
        if (n5 == 4 && n4 == 2) {
            return false;
        }
        if (n5 == 1 && n4 == 5) {
            return false;
        }
        return n5 != 2 || n4 != 4;
    }

    private boolean hasNeighborSignal(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        if (n4 == 5 && level.getSignal(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (n4 == 3 && level.getSignal(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (n4 == 4 && level.getSignal(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (n4 == 1 && level.getSignal(n - 1, n2, n3, 4)) {
            return true;
        }
        return n4 == 2 && level.getSignal(n + 1, n2, n3, 5);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        boolean bl = this.hasNeighborSignal(level, n, n2, n3);
        while (recentToggles.size() > 0 && level.time - NotGateTile.recentToggles.get((int)0).when > 100L) {
            recentToggles.remove(0);
        }
        if (this.on) {
            if (bl) {
                level.setTileAndData(n, n2, n3, Tile.notGate_off.id, level.getData(n, n2, n3));
                if (this.isToggledTooFrequently(level, n, n2, n3, true)) {
                    level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "random.fizz", 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double d = (double)n + random.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)n2 + random.nextDouble() * 0.6 + 0.2;
                        double d3 = (double)n3 + random.nextDouble() * 0.6 + 0.2;
                        level.addParticle("smoke", d, d2, d3, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if (!bl && !this.isToggledTooFrequently(level, n, n2, n3, false)) {
            level.setTileAndData(n, n2, n3, Tile.notGate_on.id, level.getData(n, n2, n3));
        }
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        super.neighborChanged(level, n, n2, n3, n4);
        level.addToTickNextTick(n, n2, n3, this.id);
    }

    public boolean getDirectSignal(Level level, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return this.getSignal(level, n, n2, n3, n4);
        }
        return false;
    }

    public int getResource(int n, Random random) {
        return Tile.notGate_on.id;
    }

    public boolean isSignalSource() {
        return true;
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        if (!this.on) {
            return;
        }
        int n4 = level.getData(n, n2, n3);
        double d = (double)((float)n + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d2 = (double)((float)n2 + 0.7f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d3 = (double)((float)n3 + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d4 = 0.22f;
        double d5 = 0.27f;
        if (n4 == 1) {
            level.addParticle("reddust", d - d5, d2 + d4, d3, 0.0, 0.0, 0.0);
        } else if (n4 == 2) {
            level.addParticle("reddust", d + d5, d2 + d4, d3, 0.0, 0.0, 0.0);
        } else if (n4 == 3) {
            level.addParticle("reddust", d, d2 + d4, d3 - d5, 0.0, 0.0, 0.0);
        } else if (n4 == 4) {
            level.addParticle("reddust", d, d2 + d4, d3 + d5, 0.0, 0.0, 0.0);
        } else {
            level.addParticle("reddust", d, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    private static class Toggle {
        int x;
        int y;
        int z;
        long when;

        public Toggle(int n, int n2, int n3, long l) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.when = l;
        }
    }
}

