/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.EntityTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.MusicTileEntity;
import net.minecraft.world.level.tile.entity.TileEntity;

public class MusicTile
extends EntityTile {
    public MusicTile(int n) {
        super(n, 74, Material.wood);
    }

    public int getTexture(int n) {
        return this.tex;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Tile.tiles[n4].isSignalSource()) {
            boolean bl = level.hasDirectSignal(n, n2, n3);
            MusicTileEntity musicTileEntity = (MusicTileEntity)level.getTileEntity(n, n2, n3);
            if (musicTileEntity.on != bl) {
                if (bl) {
                    musicTileEntity.playNote(level, n, n2, n3);
                }
                musicTileEntity.on = bl;
            }
        }
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        if (level.isOnline) {
            return true;
        }
        MusicTileEntity musicTileEntity = (MusicTileEntity)level.getTileEntity(n, n2, n3);
        musicTileEntity.tune();
        musicTileEntity.playNote(level, n, n2, n3);
        return true;
    }

    public void attack(Level level, int n, int n2, int n3, Player player) {
        if (level.isOnline) {
            return;
        }
        MusicTileEntity musicTileEntity = (MusicTileEntity)level.getTileEntity(n, n2, n3);
        musicTileEntity.playNote(level, n, n2, n3);
    }

    protected TileEntity newTileEntity() {
        return new MusicTileEntity();
    }

    public void triggerEvent(Level level, int n, int n2, int n3, int n4, int n5) {
        float f = (float)Math.pow(2.0, (double)(n5 - 12) / 12.0);
        String string = "harp";
        if (n4 == 1) {
            string = "bd";
        }
        if (n4 == 2) {
            string = "snare";
        }
        if (n4 == 3) {
            string = "hat";
        }
        if (n4 == 4) {
            string = "bassattack";
        }
        level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "note." + string, 3.0f, f);
        level.addParticle("note", (double)n + 0.5, (double)n2 + 1.2, (double)n3 + 0.5, (double)n5 / 24.0, 0.0, 0.0);
    }
}

