/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.LiquidTile;
import net.minecraft.world.level.tile.Tile;

public class LiquidTileStatic
extends LiquidTile {
    protected LiquidTileStatic(int n, Material material) {
        super(n, material);
        this.setTicking(false);
        if (material == Material.lava) {
            this.setTicking(true);
        }
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        super.neighborChanged(level, n, n2, n3, n4);
        if (level.getTile(n, n2, n3) == this.id) {
            this.setDynamic(level, n, n2, n3);
        }
    }

    private void setDynamic(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        level.noNeighborUpdate = true;
        level.setTileAndDataNoUpdate(n, n2, n3, this.id - 1, n4);
        level.setTilesDirty(n, n2, n3, n, n2, n3);
        level.addToTickNextTick(n, n2, n3, this.id - 1);
        level.noNeighborUpdate = false;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (this.material == Material.lava) {
            int n4 = random.nextInt(3);
            for (int i = 0; i < n4; ++i) {
                int n5 = level.getTile(n += random.nextInt(3) - 1, ++n2, n3 += random.nextInt(3) - 1);
                if (n5 == 0) {
                    if (!this.isFlammable(level, n - 1, n2, n3) && !this.isFlammable(level, n + 1, n2, n3) && !this.isFlammable(level, n, n2, n3 - 1) && !this.isFlammable(level, n, n2, n3 + 1) && !this.isFlammable(level, n, n2 - 1, n3) && !this.isFlammable(level, n, n2 + 1, n3)) continue;
                    level.setTile(n, n2, n3, Tile.fire.id);
                    return;
                }
                if (!Tile.tiles[n5].material.blocksMotion()) continue;
                return;
            }
        }
    }

    private boolean isFlammable(Level level, int n, int n2, int n3) {
        return level.getMaterial(n, n2, n3).isFlammable();
    }
}

