/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.LiquidTile;
import net.minecraft.world.level.tile.Tile;

public class LiquidTileDynamic
extends LiquidTile {
    int maxCount = 0;
    boolean[] result = new boolean[4];
    int[] dist = new int[4];

    protected LiquidTileDynamic(int n, Material material) {
        super(n, material);
    }

    private void setStatic(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        level.setTileAndDataNoUpdate(n, n2, n3, this.id + 1, n4);
        level.setTilesDirty(n, n2, n3, n, n2, n3);
        level.sendTileUpdated(n, n2, n3);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        int n4;
        int n5 = this.getDepth(level, n, n2, n3);
        int n6 = 1;
        if (this.material == Material.lava && !level.dimension.ultraWarm) {
            n6 = 2;
        }
        boolean bl = true;
        if (n5 > 0) {
            int n7 = -100;
            this.maxCount = 0;
            n7 = this.getHighest(level, n - 1, n2, n3, n7);
            n7 = this.getHighest(level, n + 1, n2, n3, n7);
            n7 = this.getHighest(level, n, n2, n3 - 1, n7);
            n4 = (n7 = this.getHighest(level, n, n2, n3 + 1, n7)) + n6;
            if (n4 >= 8 || n7 < 0) {
                n4 = -1;
            }
            if (this.getDepth(level, n, n2 + 1, n3) >= 0) {
                int n8 = this.getDepth(level, n, n2 + 1, n3);
                n4 = n8 >= 8 ? n8 : n8 + 8;
            }
            if (this.maxCount >= 2 && this.material == Material.water) {
                if (level.isSolidTile(n, n2 - 1, n3)) {
                    n4 = 0;
                } else if (level.getMaterial(n, n2 - 1, n3) == this.material && level.getData(n, n2, n3) == 0) {
                    n4 = 0;
                }
            }
            if (this.material == Material.lava && n5 < 8 && n4 < 8 && n4 > n5 && random.nextInt(4) != 0) {
                n4 = n5;
                bl = false;
            }
            if (n4 != n5) {
                n5 = n4;
                if (n5 < 0) {
                    level.setTile(n, n2, n3, 0);
                } else {
                    level.setData(n, n2, n3, n5);
                    level.addToTickNextTick(n, n2, n3, this.id);
                    level.updateNeighborsAt(n, n2, n3, this.id);
                }
            } else if (bl) {
                this.setStatic(level, n, n2, n3);
            }
        } else {
            this.setStatic(level, n, n2, n3);
        }
        if (this.canSpreadTo(level, n, n2 - 1, n3)) {
            if (n5 >= 8) {
                level.setTileAndData(n, n2 - 1, n3, this.id, n5);
            } else {
                level.setTileAndData(n, n2 - 1, n3, this.id, n5 + 8);
            }
        } else if (n5 >= 0 && (n5 == 0 || this.isWaterBlocking(level, n, n2 - 1, n3))) {
            boolean[] blArray = this.getSpread(level, n, n2, n3);
            n4 = n5 + n6;
            if (n5 >= 8) {
                n4 = 1;
            }
            if (n4 >= 8) {
                return;
            }
            if (blArray[0]) {
                this.trySpreadTo(level, n - 1, n2, n3, n4);
            }
            if (blArray[1]) {
                this.trySpreadTo(level, n + 1, n2, n3, n4);
            }
            if (blArray[2]) {
                this.trySpreadTo(level, n, n2, n3 - 1, n4);
            }
            if (blArray[3]) {
                this.trySpreadTo(level, n, n2, n3 + 1, n4);
            }
        }
    }

    private void trySpreadTo(Level level, int n, int n2, int n3, int n4) {
        if (this.canSpreadTo(level, n, n2, n3)) {
            int n5 = level.getTile(n, n2, n3);
            if (n5 > 0) {
                if (this.material == Material.lava) {
                    this.fizz(level, n, n2, n3);
                } else {
                    Tile.tiles[n5].spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
                }
            }
            level.setTileAndData(n, n2, n3, this.id, n4);
        }
    }

    private int getSlopeDistance(Level level, int n, int n2, int n3, int n4, int n5) {
        int n6 = 1000;
        for (int i = 0; i < 4; ++i) {
            int n7;
            if (i == 0 && n5 == 1 || i == 1 && n5 == 0 || i == 2 && n5 == 3 || i == 3 && n5 == 2) continue;
            int n8 = n;
            int n9 = n2;
            int n10 = n3;
            if (i == 0) {
                --n8;
            }
            if (i == 1) {
                ++n8;
            }
            if (i == 2) {
                --n10;
            }
            if (i == 3) {
                ++n10;
            }
            if (this.isWaterBlocking(level, n8, n9, n10) || level.getMaterial(n8, n9, n10) == this.material && level.getData(n8, n9, n10) == 0) continue;
            if (!this.isWaterBlocking(level, n8, n9 - 1, n10)) {
                return n4;
            }
            if (n4 >= 4 || (n7 = this.getSlopeDistance(level, n8, n9, n10, n4 + 1, i)) >= n6) continue;
            n6 = n7;
        }
        return n6;
    }

    private boolean[] getSpread(Level level, int n, int n2, int n3) {
        int n4;
        int n5;
        for (n5 = 0; n5 < 4; ++n5) {
            this.dist[n5] = 1000;
            n4 = n;
            int n6 = n2;
            int n7 = n3;
            if (n5 == 0) {
                --n4;
            }
            if (n5 == 1) {
                ++n4;
            }
            if (n5 == 2) {
                --n7;
            }
            if (n5 == 3) {
                ++n7;
            }
            if (this.isWaterBlocking(level, n4, n6, n7) || level.getMaterial(n4, n6, n7) == this.material && level.getData(n4, n6, n7) == 0) continue;
            this.dist[n5] = !this.isWaterBlocking(level, n4, n6 - 1, n7) ? 0 : this.getSlopeDistance(level, n4, n6, n7, 1, n5);
        }
        n5 = this.dist[0];
        for (n4 = 1; n4 < 4; ++n4) {
            if (this.dist[n4] >= n5) continue;
            n5 = this.dist[n4];
        }
        for (n4 = 0; n4 < 4; ++n4) {
            this.result[n4] = this.dist[n4] == n5;
        }
        return this.result;
    }

    private boolean isWaterBlocking(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3);
        if (n4 == Tile.door_wood.id || n4 == Tile.door_iron.id || n4 == Tile.sign.id || n4 == Tile.ladder.id || n4 == Tile.reeds.id) {
            return true;
        }
        if (n4 == 0) {
            return false;
        }
        Material material = Tile.tiles[n4].material;
        return material.isSolid();
    }

    protected int getHighest(Level level, int n, int n2, int n3, int n4) {
        int n5 = this.getDepth(level, n, n2, n3);
        if (n5 < 0) {
            return n4;
        }
        if (n5 == 0) {
            ++this.maxCount;
        }
        if (n5 >= 8) {
            n5 = 0;
        }
        return n4 < 0 || n5 < n4 ? n5 : n4;
    }

    private boolean canSpreadTo(Level level, int n, int n2, int n3) {
        Material material = level.getMaterial(n, n2, n3);
        if (material == this.material) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.isWaterBlocking(level, n, n2, n3);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        super.onPlace(level, n, n2, n3);
        if (level.getTile(n, n2, n3) == this.id) {
            level.addToTickNextTick(n, n2, n3, this.id);
        }
    }
}

