/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class LiquidTile
extends Tile {
    protected LiquidTile(int n, Material material) {
        super(n, (material == Material.lava ? 14 : 12) * 16 + 13, material);
        float f = 0.0f;
        float f2 = 0.0f;
        this.setShape(0.0f + f2, 0.0f + f, 0.0f + f2, 1.0f + f2, 1.0f + f, 1.0f + f2);
        this.setTicking(true);
    }

    public static float getHeight(int n) {
        if (n >= 8) {
            n = 0;
        }
        float f = (float)(n + 1) / 9.0f;
        return f;
    }

    public int getTexture(int n) {
        if (n == 0 || n == 1) {
            return this.tex;
        }
        return this.tex + 1;
    }

    protected int getDepth(Level level, int n, int n2, int n3) {
        if (level.getMaterial(n, n2, n3) != this.material) {
            return -1;
        }
        return level.getData(n, n2, n3);
    }

    protected int getRenderedDepth(LevelSource levelSource, int n, int n2, int n3) {
        if (levelSource.getMaterial(n, n2, n3) != this.material) {
            return -1;
        }
        int n4 = levelSource.getData(n, n2, n3);
        if (n4 >= 8) {
            n4 = 0;
        }
        return n4;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean mayPick(int n, boolean bl) {
        return bl && n == 0;
    }

    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        Material material = levelSource.getMaterial(n, n2, n3);
        if (material == this.material) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (n4 == 1) {
            return true;
        }
        return super.shouldRenderFace(levelSource, n, n2, n3, n4);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public int getRenderShape() {
        return 4;
    }

    public int getResource(int n, Random random) {
        return 0;
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    private Vec3 getFlow(LevelSource levelSource, int n, int n2, int n3) {
        int n4;
        Vec3 vec3 = Vec3.newTemp(0.0, 0.0, 0.0);
        int n5 = this.getRenderedDepth(levelSource, n, n2, n3);
        for (n4 = 0; n4 < 4; ++n4) {
            int n6;
            int n7;
            int n8 = n;
            int n9 = n2;
            int n10 = n3;
            if (n4 == 0) {
                --n8;
            }
            if (n4 == 1) {
                --n10;
            }
            if (n4 == 2) {
                ++n8;
            }
            if (n4 == 3) {
                ++n10;
            }
            if ((n7 = this.getRenderedDepth(levelSource, n8, n9, n10)) < 0) {
                if (levelSource.getMaterial(n8, n9, n10).blocksMotion() || (n7 = this.getRenderedDepth(levelSource, n8, n9 - 1, n10)) < 0) continue;
                n6 = n7 - (n5 - 8);
                vec3 = vec3.add((n8 - n) * n6, (n9 - n2) * n6, (n10 - n3) * n6);
                continue;
            }
            if (n7 < 0) continue;
            n6 = n7 - n5;
            vec3 = vec3.add((n8 - n) * n6, (n9 - n2) * n6, (n10 - n3) * n6);
        }
        if (levelSource.getData(n, n2, n3) >= 8) {
            n4 = 0;
            if (n4 != 0 || this.shouldRenderFace(levelSource, n, n2, n3 - 1, 2)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n, n2, n3 + 1, 3)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n - 1, n2, n3, 4)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n + 1, n2, n3, 5)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n, n2 + 1, n3 - 1, 2)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n, n2 + 1, n3 + 1, 3)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n - 1, n2 + 1, n3, 4)) {
                n4 = 1;
            }
            if (n4 != 0 || this.shouldRenderFace(levelSource, n + 1, n2 + 1, n3, 5)) {
                n4 = 1;
            }
            if (n4 != 0) {
                vec3 = vec3.normalize().add(0.0, -6.0, 0.0);
            }
        }
        vec3 = vec3.normalize();
        return vec3;
    }

    public void handleEntityInside(Level level, int n, int n2, int n3, Entity entity, Vec3 vec3) {
        Vec3 vec32 = this.getFlow(level, n, n2, n3);
        vec3.x += vec32.x;
        vec3.y += vec32.y;
        vec3.z += vec32.z;
    }

    public int getTickDelay() {
        if (this.material == Material.water) {
            return 5;
        }
        if (this.material == Material.lava) {
            return 30;
        }
        return 0;
    }

    public float getBrightness(LevelSource levelSource, int n, int n2, int n3) {
        float f;
        float f2 = levelSource.getBrightness(n, n2, n3);
        return f2 > (f = levelSource.getBrightness(n, n2 + 1, n3)) ? f2 : f;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        super.tick(level, n, n2, n3, random);
    }

    public int getRenderLayer() {
        return this.material == Material.water ? 1 : 0;
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        int n4;
        if (this.material == Material.water && random.nextInt(64) == 0 && (n4 = level.getData(n, n2, n3)) > 0 && n4 < 8) {
            level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "liquid.water", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
        }
        if (this.material == Material.lava && level.getMaterial(n, n2 + 1, n3) == Material.air && !level.isSolidTile(n, n2 + 1, n3) && random.nextInt(100) == 0) {
            double d = (float)n + random.nextFloat();
            double d2 = (double)n2 + this.yy1;
            double d3 = (float)n3 + random.nextFloat();
            level.addParticle("lava", d, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    public static double getSlopeAngle(LevelSource levelSource, int n, int n2, int n3, Material material) {
        Vec3 vec3 = null;
        if (material == Material.water) {
            vec3 = ((LiquidTile)Tile.water).getFlow(levelSource, n, n2, n3);
        }
        if (material == Material.lava) {
            vec3 = ((LiquidTile)Tile.lava).getFlow(levelSource, n, n2, n3);
        }
        if (vec3.x == 0.0 && vec3.z == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3.z, vec3.x) - 1.5707963267948966;
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        this.updateLiquid(level, n, n2, n3);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        this.updateLiquid(level, n, n2, n3);
    }

    private void updateLiquid(Level level, int n, int n2, int n3) {
        if (level.getTile(n, n2, n3) != this.id) {
            return;
        }
        if (this.material == Material.lava) {
            boolean bl = false;
            if (bl || level.getMaterial(n, n2, n3 - 1) == Material.water) {
                bl = true;
            }
            if (bl || level.getMaterial(n, n2, n3 + 1) == Material.water) {
                bl = true;
            }
            if (bl || level.getMaterial(n - 1, n2, n3) == Material.water) {
                bl = true;
            }
            if (bl || level.getMaterial(n + 1, n2, n3) == Material.water) {
                bl = true;
            }
            if (bl || level.getMaterial(n, n2 + 1, n3) == Material.water) {
                bl = true;
            }
            if (bl) {
                int n4 = level.getData(n, n2, n3);
                if (n4 == 0) {
                    level.setTile(n, n2, n3, Tile.obsidian.id);
                } else if (n4 <= 4) {
                    level.setTile(n, n2, n3, Tile.stoneBrick.id);
                }
                this.fizz(level, n, n2, n3);
            }
        }
    }

    protected void fizz(Level level, int n, int n2, int n3) {
        level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "random.fizz", 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            level.addParticle("largesmoke", (double)n + Math.random(), (double)n2 + 1.2, (double)n3 + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

