/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class LeverTile
extends Tile {
    protected LeverTile(int n, int n2) {
        super(n, n2, Material.decoration);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 12;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (level.isSolidTile(n - 1, n2, n3)) {
            return true;
        }
        if (level.isSolidTile(n + 1, n2, n3)) {
            return true;
        }
        if (level.isSolidTile(n, n2, n3 - 1)) {
            return true;
        }
        if (level.isSolidTile(n, n2, n3 + 1)) {
            return true;
        }
        return level.isSolidTile(n, n2 - 1, n3);
    }

    public void setPlacedOnFace(Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getData(n, n2, n3);
        int n6 = n5 & 8;
        n5 &= 7;
        if (n4 == 1 && level.isSolidTile(n, n2 - 1, n3)) {
            n5 = 5 + level.random.nextInt(2);
        }
        if (n4 == 2 && level.isSolidTile(n, n2, n3 + 1)) {
            n5 = 4;
        }
        if (n4 == 3 && level.isSolidTile(n, n2, n3 - 1)) {
            n5 = 3;
        }
        if (n4 == 4 && level.isSolidTile(n + 1, n2, n3)) {
            n5 = 2;
        }
        if (n4 == 5 && level.isSolidTile(n - 1, n2, n3)) {
            n5 = 1;
        }
        level.setData(n, n2, n3, n5 + n6);
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        if (level.isSolidTile(n - 1, n2, n3)) {
            level.setData(n, n2, n3, 1);
        } else if (level.isSolidTile(n + 1, n2, n3)) {
            level.setData(n, n2, n3, 2);
        } else if (level.isSolidTile(n, n2, n3 - 1)) {
            level.setData(n, n2, n3, 3);
        } else if (level.isSolidTile(n, n2, n3 + 1)) {
            level.setData(n, n2, n3, 4);
        } else if (level.isSolidTile(n, n2 - 1, n3)) {
            level.setData(n, n2, n3, 5 + level.random.nextInt(2));
        }
        this.checkCanSurvive(level, n, n2, n3);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (this.checkCanSurvive(level, n, n2, n3)) {
            int n5 = level.getData(n, n2, n3) & 7;
            boolean bl = false;
            if (!level.isSolidTile(n - 1, n2, n3) && n5 == 1) {
                bl = true;
            }
            if (!level.isSolidTile(n + 1, n2, n3) && n5 == 2) {
                bl = true;
            }
            if (!level.isSolidTile(n, n2, n3 - 1) && n5 == 3) {
                bl = true;
            }
            if (!level.isSolidTile(n, n2, n3 + 1) && n5 == 4) {
                bl = true;
            }
            if (!level.isSolidTile(n, n2 - 1, n3) && n5 == 5) {
                bl = true;
            }
            if (bl) {
                this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
                level.setTile(n, n2, n3, 0);
            }
        }
    }

    private boolean checkCanSurvive(Level level, int n, int n2, int n3) {
        if (!this.mayPlace(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
            return false;
        }
        return true;
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        int n4 = levelSource.getData(n, n2, n3) & 7;
        float f = 0.1875f;
        if (n4 == 1) {
            this.setShape(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (n4 == 2) {
            this.setShape(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (n4 == 3) {
            this.setShape(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (n4 == 4) {
            this.setShape(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            f = 0.25f;
            this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.6f, 0.5f + f);
        }
    }

    public void attack(Level level, int n, int n2, int n3, Player player) {
        this.use(level, n, n2, n3, player);
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        if (level.isOnline) {
            return true;
        }
        int n4 = level.getData(n, n2, n3);
        int n5 = n4 & 7;
        int n6 = 8 - (n4 & 8);
        level.setData(n, n2, n3, n5 + n6);
        level.setTilesDirty(n, n2, n3, n, n2, n3);
        level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.click", 0.3f, n6 > 0 ? 0.6f : 0.5f);
        level.updateNeighborsAt(n, n2, n3, this.id);
        if (n5 == 1) {
            level.updateNeighborsAt(n - 1, n2, n3, this.id);
        } else if (n5 == 2) {
            level.updateNeighborsAt(n + 1, n2, n3, this.id);
        } else if (n5 == 3) {
            level.updateNeighborsAt(n, n2, n3 - 1, this.id);
        } else if (n5 == 4) {
            level.updateNeighborsAt(n, n2, n3 + 1, this.id);
        } else {
            level.updateNeighborsAt(n, n2 - 1, n3, this.id);
        }
        return true;
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        if ((n4 & 8) > 0) {
            level.updateNeighborsAt(n, n2, n3, this.id);
            int n5 = n4 & 7;
            if (n5 == 1) {
                level.updateNeighborsAt(n - 1, n2, n3, this.id);
            } else if (n5 == 2) {
                level.updateNeighborsAt(n + 1, n2, n3, this.id);
            } else if (n5 == 3) {
                level.updateNeighborsAt(n, n2, n3 - 1, this.id);
            } else if (n5 == 4) {
                level.updateNeighborsAt(n, n2, n3 + 1, this.id);
            } else {
                level.updateNeighborsAt(n, n2 - 1, n3, this.id);
            }
        }
        super.onRemove(level, n, n2, n3);
    }

    public boolean getSignal(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return (levelSource.getData(n, n2, n3) & 8) > 0;
    }

    public boolean getDirectSignal(Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getData(n, n2, n3);
        if ((n5 & 8) == 0) {
            return false;
        }
        int n6 = n5 & 7;
        if (n6 == 5 && n4 == 1) {
            return true;
        }
        if (n6 == 4 && n4 == 2) {
            return true;
        }
        if (n6 == 3 && n4 == 3) {
            return true;
        }
        if (n6 == 2 && n4 == 4) {
            return true;
        }
        return n6 == 1 && n4 == 5;
    }

    public boolean isSignalSource() {
        return true;
    }
}

