/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.TransparentTile;

public class LeafTile
extends TransparentTile {
    public static final int REQUIRED_WOOD_RANGE = 4;
    public static final int UPDATE_LEAF_BIT = 4;
    public static final int NORMAL_LEAF = 0;
    public static final int EVERGREEN_LEAF = 1;
    public static final int BIRCH_LEAF = 2;
    private static final int LEAF_TYPE_MASK = 3;
    private int oTex;
    int[] checkBuffer;

    protected LeafTile(int n, int n2) {
        super(n, n2, Material.leaves, false);
        this.oTex = n2;
        this.setTicking(true);
    }

    public int getColor(LevelSource levelSource, int n, int n2, int n3) {
        int n4 = levelSource.getData(n, n2, n3);
        if ((n4 & 1) == 1) {
            return FoliageColor.getEvergreenColor();
        }
        if ((n4 & 2) == 2) {
            return FoliageColor.getBirchColor();
        }
        levelSource.getBiomeSource().getBiomeBlock(n, n3, 1, 1);
        double d = levelSource.getBiomeSource().temperatures[0];
        double d2 = levelSource.getBiomeSource().downfalls[0];
        return FoliageColor.get(d, d2);
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        int n4 = 1;
        int n5 = n4 + 1;
        if (level.hasChunksAt(n - n5, n2 - n5, n3 - n5, n + n5, n2 + n5, n3 + n5)) {
            for (int i = -n4; i <= n4; ++i) {
                for (int j = -n4; j <= n4; ++j) {
                    for (int k = -n4; k <= n4; ++k) {
                        int n6 = level.getTile(n + i, n2 + j, n3 + k);
                        if (n6 != Tile.leaves.id) continue;
                        int n7 = level.getData(n + i, n2 + j, n3 + k);
                        level.setDataNoUpdate(n + i, n2 + j, n3 + k, n7 | 4);
                    }
                }
            }
        }
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.isOnline) {
            return;
        }
        int n4 = level.getData(n, n2, n3);
        if ((n4 & 4) != 0) {
            int n5;
            int n6 = 4;
            int n7 = n6 + 1;
            int n8 = 32;
            int n9 = n8 * n8;
            int n10 = n8 / 2;
            if (this.checkBuffer == null) {
                this.checkBuffer = new int[n8 * n8 * n8];
            }
            if (level.hasChunksAt(n - n7, n2 - n7, n3 - n7, n + n7, n2 + n7, n3 + n7)) {
                int n11;
                int n12;
                int n13;
                for (n5 = -n6; n5 <= n6; ++n5) {
                    for (n13 = -n6; n13 <= n6; ++n13) {
                        for (n12 = -n6; n12 <= n6; ++n12) {
                            n11 = level.getTile(n + n5, n2 + n13, n3 + n12);
                            this.checkBuffer[(n5 + n10) * n9 + (n13 + n10) * n8 + (n12 + n10)] = n11 == Tile.treeTrunk.id ? 0 : (n11 == Tile.leaves.id ? -2 : -1);
                        }
                    }
                }
                for (n5 = 1; n5 <= 4; ++n5) {
                    for (n13 = -n6; n13 <= n6; ++n13) {
                        for (n12 = -n6; n12 <= n6; ++n12) {
                            for (n11 = -n6; n11 <= n6; ++n11) {
                                if (this.checkBuffer[(n13 + n10) * n9 + (n12 + n10) * n8 + (n11 + n10)] != n5 - 1) continue;
                                if (this.checkBuffer[(n13 + n10 - 1) * n9 + (n12 + n10) * n8 + (n11 + n10)] == -2) {
                                    this.checkBuffer[(n13 + n10 - 1) * n9 + (n12 + n10) * n8 + (n11 + n10)] = n5;
                                }
                                if (this.checkBuffer[(n13 + n10 + 1) * n9 + (n12 + n10) * n8 + (n11 + n10)] == -2) {
                                    this.checkBuffer[(n13 + n10 + 1) * n9 + (n12 + n10) * n8 + (n11 + n10)] = n5;
                                }
                                if (this.checkBuffer[(n13 + n10) * n9 + (n12 + n10 - 1) * n8 + (n11 + n10)] == -2) {
                                    this.checkBuffer[(n13 + n10) * n9 + (n12 + n10 - 1) * n8 + (n11 + n10)] = n5;
                                }
                                if (this.checkBuffer[(n13 + n10) * n9 + (n12 + n10 + 1) * n8 + (n11 + n10)] == -2) {
                                    this.checkBuffer[(n13 + n10) * n9 + (n12 + n10 + 1) * n8 + (n11 + n10)] = n5;
                                }
                                if (this.checkBuffer[(n13 + n10) * n9 + (n12 + n10) * n8 + (n11 + n10 - 1)] == -2) {
                                    this.checkBuffer[(n13 + n10) * n9 + (n12 + n10) * n8 + (n11 + n10 - 1)] = n5;
                                }
                                if (this.checkBuffer[(n13 + n10) * n9 + (n12 + n10) * n8 + (n11 + n10 + 1)] != -2) continue;
                                this.checkBuffer[(n13 + n10) * n9 + (n12 + n10) * n8 + (n11 + n10 + 1)] = n5;
                            }
                        }
                    }
                }
            }
            if ((n5 = this.checkBuffer[n10 * n9 + n10 * n8 + n10]) >= 0) {
                level.setData(n, n2, n3, n4 & 0xFFFFFFFB);
            } else {
                this.die(level, n, n2, n3);
            }
        }
    }

    private void die(Level level, int n, int n2, int n3) {
        this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
        level.setTile(n, n2, n3, 0);
    }

    public int getResourceCount(Random random) {
        return random.nextInt(16) == 0 ? 1 : 0;
    }

    public int getResource(int n, Random random) {
        return Tile.sapling.id;
    }

    public boolean isSolidRender() {
        return !this.allowSame;
    }

    public int getTexture(int n, int n2) {
        if ((n2 & 3) == 1) {
            return this.tex + 80;
        }
        return this.tex;
    }

    public void setFancy(boolean bl) {
        this.allowSame = bl;
        this.tex = this.oTex + (bl ? 0 : 1);
    }

    public void stepOn(Level level, int n, int n2, int n3, Entity entity) {
        super.stepOn(level, n, n2, n3, entity);
    }
}

