/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class LadderTile
extends Tile {
    protected LadderTile(int n, int n2) {
        super(n, n2, Material.decoration);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        float f = 0.125f;
        if (n4 == 2) {
            this.setShape(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (n4 == 3) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (n4 == 4) {
            this.setShape(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (n4 == 5) {
            this.setShape(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
        return super.getAABB(level, n, n2, n3);
    }

    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        float f = 0.125f;
        if (n4 == 2) {
            this.setShape(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (n4 == 3) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (n4 == 4) {
            this.setShape(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (n4 == 5) {
            this.setShape(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
        return super.getTileAABB(level, n, n2, n3);
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 8;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (level.isSolidTile(n - 1, n2, n3)) {
            return true;
        }
        if (level.isSolidTile(n + 1, n2, n3)) {
            return true;
        }
        if (level.isSolidTile(n, n2, n3 - 1)) {
            return true;
        }
        return level.isSolidTile(n, n2, n3 + 1);
    }

    public void setPlacedOnFace(Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getData(n, n2, n3);
        if ((n5 == 0 || n4 == 2) && level.isSolidTile(n, n2, n3 + 1)) {
            n5 = 2;
        }
        if ((n5 == 0 || n4 == 3) && level.isSolidTile(n, n2, n3 - 1)) {
            n5 = 3;
        }
        if ((n5 == 0 || n4 == 4) && level.isSolidTile(n + 1, n2, n3)) {
            n5 = 4;
        }
        if ((n5 == 0 || n4 == 5) && level.isSolidTile(n - 1, n2, n3)) {
            n5 = 5;
        }
        level.setData(n, n2, n3, n5);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getData(n, n2, n3);
        boolean bl = false;
        if (n5 == 2 && level.isSolidTile(n, n2, n3 + 1)) {
            bl = true;
        }
        if (n5 == 3 && level.isSolidTile(n, n2, n3 - 1)) {
            bl = true;
        }
        if (n5 == 4 && level.isSolidTile(n + 1, n2, n3)) {
            bl = true;
        }
        if (n5 == 5 && level.isSolidTile(n - 1, n2, n3)) {
            bl = true;
        }
        if (!bl) {
            this.spawnResources(level, n, n2, n3, n5);
            level.setTile(n, n2, n3, 0);
        }
        super.neighborChanged(level, n, n2, n3, n4);
    }

    public int getResourceCount(Random random) {
        return 1;
    }
}

