/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.HalfTransparentTile;
import net.minecraft.world.level.tile.Tile;

public class IceTile
extends HalfTransparentTile {
    public IceTile(int n, int n2) {
        super(n, n2, Material.ice, false);
        this.friction = 0.98f;
        this.setTicking(true);
    }

    public int getRenderLayer() {
        return 1;
    }

    public boolean shouldRenderFace(LevelSource levelSource, int n, int n2, int n3, int n4) {
        return super.shouldRenderFace(levelSource, n, n2, n3, 1 - n4);
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        Material material = level.getMaterial(n, n2 - 1, n3);
        if (material.blocksMotion() || material.isLiquid()) {
            level.setTile(n, n2, n3, Tile.water.id);
        }
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.getBrightness(LightLayer.Block, n, n2, n3) > 11 - Tile.lightBlock[this.id]) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, Tile.calmWater.id);
        }
    }
}

