/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;

public class GrassTile
extends Tile {
    public static final int MIN_BRIGHTNESS = 4;

    protected GrassTile(int n) {
        super(n, Material.dirt);
        this.tex = 3;
        this.setTicking(true);
    }

    public int getTexture(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (n4 == 1) {
            return 0;
        }
        if (n4 == 0) {
            return 2;
        }
        Material material = levelSource.getMaterial(n, n2 + 1, n3);
        if (material == Material.topSnow || material == Material.snow) {
            return 68;
        }
        return 3;
    }

    public int getColor(LevelSource levelSource, int n, int n2, int n3) {
        levelSource.getBiomeSource().getBiomeBlock(n, n3, 1, 1);
        double d = levelSource.getBiomeSource().temperatures[0];
        double d2 = levelSource.getBiomeSource().downfalls[0];
        return GrassColor.get(d, d2);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        int n4;
        int n5;
        int n6;
        if (level.isOnline) {
            return;
        }
        if (level.getRawBrightness(n, n2 + 1, n3) < 4 && level.getMaterial(n, n2 + 1, n3).blocksLight()) {
            if (random.nextInt(4) != 0) {
                return;
            }
            level.setTile(n, n2, n3, Tile.dirt.id);
        } else if (level.getRawBrightness(n, n2 + 1, n3) >= 9 && level.getTile(n6 = n + random.nextInt(3) - 1, n5 = n2 + random.nextInt(5) - 3, n4 = n3 + random.nextInt(3) - 1) == Tile.dirt.id && level.getRawBrightness(n6, n5 + 1, n4) >= 4 && !level.getMaterial(n6, n5 + 1, n4).blocksLight()) {
            level.setTile(n6, n5, n4, Tile.grass.id);
        }
    }

    public int getResource(int n, Random random) {
        return Tile.dirt.getResource(0, random);
    }
}

