/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.EntityTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.FurnaceTileEntity;
import net.minecraft.world.level.tile.entity.TileEntity;
import util.Mth;

public class FurnaceTile
extends EntityTile {
    private final boolean lit;

    protected FurnaceTile(int n, boolean bl) {
        super(n, Material.stone);
        this.lit = bl;
        this.tex = 45;
    }

    public int getResource(int n, Random random) {
        return Tile.furnace.id;
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        super.onPlace(level, n, n2, n3);
        this.recalcLockDir(level, n, n2, n3);
    }

    private void recalcLockDir(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3 - 1);
        int n5 = level.getTile(n, n2, n3 + 1);
        int n6 = level.getTile(n - 1, n2, n3);
        int n7 = level.getTile(n + 1, n2, n3);
        int n8 = 3;
        if (Tile.solid[n4] && !Tile.solid[n5]) {
            n8 = 3;
        }
        if (Tile.solid[n5] && !Tile.solid[n4]) {
            n8 = 2;
        }
        if (Tile.solid[n6] && !Tile.solid[n7]) {
            n8 = 5;
        }
        if (Tile.solid[n7] && !Tile.solid[n6]) {
            n8 = 4;
        }
        level.setData(n, n2, n3, n8);
    }

    public int getTexture(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (n4 == 1) {
            return this.tex + 17;
        }
        if (n4 == 0) {
            return this.tex + 17;
        }
        int n5 = levelSource.getData(n, n2, n3);
        if (n4 != n5) {
            return this.tex;
        }
        if (this.lit) {
            return this.tex + 16;
        }
        return this.tex - 1;
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        if (!this.lit) {
            return;
        }
        int n4 = level.getData(n, n2, n3);
        float f = (float)n + 0.5f;
        float f2 = (float)n2 + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f3 = (float)n3 + 0.5f;
        float f4 = 0.52f;
        float f5 = random.nextFloat() * 0.6f - 0.3f;
        if (n4 == 4) {
            level.addParticle("smoke", f - f4, f2, f3 + f5, 0.0, 0.0, 0.0);
            level.addParticle("flame", f - f4, f2, f3 + f5, 0.0, 0.0, 0.0);
        } else if (n4 == 5) {
            level.addParticle("smoke", f + f4, f2, f3 + f5, 0.0, 0.0, 0.0);
            level.addParticle("flame", f + f4, f2, f3 + f5, 0.0, 0.0, 0.0);
        } else if (n4 == 2) {
            level.addParticle("smoke", f + f5, f2, f3 - f4, 0.0, 0.0, 0.0);
            level.addParticle("flame", f + f5, f2, f3 - f4, 0.0, 0.0, 0.0);
        } else if (n4 == 3) {
            level.addParticle("smoke", f + f5, f2, f3 + f4, 0.0, 0.0, 0.0);
            level.addParticle("flame", f + f5, f2, f3 + f4, 0.0, 0.0, 0.0);
        }
    }

    public int getTexture(int n) {
        if (n == 1) {
            return this.tex + 17;
        }
        if (n == 0) {
            return this.tex + 17;
        }
        if (n == 3) {
            return this.tex - 1;
        }
        return this.tex;
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        if (level.isOnline) {
            return true;
        }
        FurnaceTileEntity furnaceTileEntity = (FurnaceTileEntity)level.getTileEntity(n, n2, n3);
        player.openFurnace(furnaceTileEntity);
        return true;
    }

    public static void setLit(boolean bl, Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        TileEntity tileEntity = level.getTileEntity(n, n2, n3);
        if (bl) {
            level.setTile(n, n2, n3, Tile.furnace_lit.id);
        } else {
            level.setTile(n, n2, n3, Tile.furnace.id);
        }
        level.setData(n, n2, n3, n4);
        level.setTileEntity(n, n2, n3, tileEntity);
    }

    protected TileEntity newTileEntity() {
        return new FurnaceTileEntity();
    }

    public void setPlacedBy(Level level, int n, int n2, int n3, Mob mob) {
        int n4 = Mth.floor((double)(mob.yRot * 4.0f / 360.0f) + 0.5) & 3;
        if (n4 == 0) {
            level.setData(n, n2, n3, 2);
        }
        if (n4 == 1) {
            level.setData(n, n2, n3, 5);
        }
        if (n4 == 2) {
            level.setData(n, n2, n3, 3);
        }
        if (n4 == 3) {
            level.setData(n, n2, n3, 4);
        }
    }
}

