/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class FireTile
extends Tile {
    public static final int FLAME_INSTANT = 60;
    public static final int FLAME_EASY = 30;
    public static final int FLAME_MEDIUM = 15;
    public static final int FLAME_HARD = 5;
    public static final int BURN_INSTANT = 100;
    public static final int BURN_EASY = 60;
    public static final int BURN_MEDIUM = 20;
    public static final int BURN_HARD = 5;
    public static final int BURN_NEVER = 0;
    private int[] flameOdds = new int[256];
    private int[] burnOdds = new int[256];

    protected FireTile(int n, int n2) {
        super(n, n2, Material.fire);
        this.setFlammable(Tile.wood.id, 5, 20);
        this.setFlammable(Tile.treeTrunk.id, 5, 5);
        this.setFlammable(Tile.leaves.id, 30, 60);
        this.setFlammable(Tile.bookshelf.id, 30, 20);
        this.setFlammable(Tile.tnt.id, 15, 100);
        this.setFlammable(Tile.cloth.id, 30, 60);
        this.setTicking(true);
    }

    private void setFlammable(int n, int n2, int n3) {
        this.flameOdds[n] = n2;
        this.burnOdds[n] = n3;
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 3;
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    public int getTickDelay() {
        return 10;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        boolean bl = level.getTile(n, n2 - 1, n3) == Tile.hellRock.id;
        int n4 = level.getData(n, n2, n3);
        if (n4 < 15) {
            level.setData(n, n2, n3, n4 + 1);
            level.addToTickNextTick(n, n2, n3, this.id);
        }
        if (!bl && !this.isValidFireLocation(level, n, n2, n3)) {
            if (!level.isSolidTile(n, n2 - 1, n3) || n4 > 3) {
                level.setTile(n, n2, n3, 0);
            }
            return;
        }
        if (!bl && !this.canBurn(level, n, n2 - 1, n3) && n4 == 15 && random.nextInt(4) == 0) {
            level.setTile(n, n2, n3, 0);
            return;
        }
        if (n4 % 2 == 0 && n4 > 2) {
            this.checkBurn(level, n + 1, n2, n3, 300, random);
            this.checkBurn(level, n - 1, n2, n3, 300, random);
            this.checkBurn(level, n, n2 - 1, n3, 250, random);
            this.checkBurn(level, n, n2 + 1, n3, 250, random);
            this.checkBurn(level, n, n2, n3 - 1, 300, random);
            this.checkBurn(level, n, n2, n3 + 1, 300, random);
            for (int i = n - 1; i <= n + 1; ++i) {
                for (int j = n3 - 1; j <= n3 + 1; ++j) {
                    for (int k = n2 - 1; k <= n2 + 4; ++k) {
                        int n5;
                        if (i == n && k == n2 && j == n3) continue;
                        int n6 = 100;
                        if (k > n2 + 1) {
                            n6 += (k - (n2 + 1)) * 100;
                        }
                        if ((n5 = this.getFireOdds(level, i, k, j)) <= 0 || random.nextInt(n6) > n5) continue;
                        level.setTile(i, k, j, this.id);
                    }
                }
            }
        }
    }

    private void checkBurn(Level level, int n, int n2, int n3, int n4, Random random) {
        int n5 = this.burnOdds[level.getTile(n, n2, n3)];
        if (random.nextInt(n4) < n5) {
            boolean bl;
            boolean bl2 = bl = level.getTile(n, n2, n3) == Tile.tnt.id;
            if (random.nextInt(2) == 0) {
                level.setTile(n, n2, n3, this.id);
            } else {
                level.setTile(n, n2, n3, 0);
            }
            if (bl) {
                Tile.tnt.destroy(level, n, n2, n3, 0);
            }
        }
    }

    private boolean isValidFireLocation(Level level, int n, int n2, int n3) {
        if (this.canBurn(level, n + 1, n2, n3)) {
            return true;
        }
        if (this.canBurn(level, n - 1, n2, n3)) {
            return true;
        }
        if (this.canBurn(level, n, n2 - 1, n3)) {
            return true;
        }
        if (this.canBurn(level, n, n2 + 1, n3)) {
            return true;
        }
        if (this.canBurn(level, n, n2, n3 - 1)) {
            return true;
        }
        return this.canBurn(level, n, n2, n3 + 1);
    }

    private int getFireOdds(Level level, int n, int n2, int n3) {
        int n4 = 0;
        if (!level.isEmptyTile(n, n2, n3)) {
            return 0;
        }
        n4 = this.getFlammability(level, n + 1, n2, n3, n4);
        n4 = this.getFlammability(level, n - 1, n2, n3, n4);
        n4 = this.getFlammability(level, n, n2 - 1, n3, n4);
        n4 = this.getFlammability(level, n, n2 + 1, n3, n4);
        n4 = this.getFlammability(level, n, n2, n3 - 1, n4);
        n4 = this.getFlammability(level, n, n2, n3 + 1, n4);
        return n4;
    }

    public boolean mayPick() {
        return false;
    }

    public boolean canBurn(LevelSource levelSource, int n, int n2, int n3) {
        return this.flameOdds[levelSource.getTile(n, n2, n3)] > 0;
    }

    public int getFlammability(Level level, int n, int n2, int n3, int n4) {
        int n5 = this.flameOdds[level.getTile(n, n2, n3)];
        if (n5 > n4) {
            return n5;
        }
        return n4;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        return level.isSolidTile(n, n2 - 1, n3) || this.isValidFireLocation(level, n, n2, n3);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (!level.isSolidTile(n, n2 - 1, n3) && !this.isValidFireLocation(level, n, n2, n3)) {
            level.setTile(n, n2, n3, 0);
            return;
        }
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        if (level.getTile(n, n2 - 1, n3) == Tile.obsidian.id && Tile.portalTile.trySpawnPortal(level, n, n2, n3)) {
            return;
        }
        if (!level.isSolidTile(n, n2 - 1, n3) && !this.isValidFireLocation(level, n, n2, n3)) {
            level.setTile(n, n2, n3, 0);
            return;
        }
        level.addToTickNextTick(n, n2, n3, this.id);
    }

    public boolean isFlammable(int n) {
        return this.flameOdds[n] > 0;
    }

    public void ignite(Level level, int n, int n2, int n3) {
        boolean bl = false;
        if (!bl) {
            bl = this.tryIgnite(level, n, n2 + 1, n3);
        }
        if (!bl) {
            bl = this.tryIgnite(level, n - 1, n2, n3);
        }
        if (!bl) {
            bl = this.tryIgnite(level, n + 1, n2, n3);
        }
        if (!bl) {
            bl = this.tryIgnite(level, n, n2, n3 - 1);
        }
        if (!bl) {
            bl = this.tryIgnite(level, n, n2, n3 + 1);
        }
        if (!bl) {
            bl = this.tryIgnite(level, n, n2 - 1, n3);
        }
        if (!bl) {
            level.setTile(n, n2, n3, Tile.fire.id);
        }
    }

    public void animateTick(Level level, int n, int n2, int n3, Random random) {
        block12: {
            float f;
            float f2;
            float f3;
            int n4;
            block11: {
                if (random.nextInt(24) == 0) {
                    level.playSound((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "fire.fire", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f);
                }
                if (!level.isSolidTile(n, n2 - 1, n3) && !Tile.fire.canBurn(level, n, n2 - 1, n3)) break block11;
                for (int i = 0; i < 3; ++i) {
                    float f4 = (float)n + random.nextFloat();
                    float f5 = (float)n2 + random.nextFloat() * 0.5f + 0.5f;
                    float f6 = (float)n3 + random.nextFloat();
                    level.addParticle("largesmoke", f4, f5, f6, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            if (Tile.fire.canBurn(level, n - 1, n2, n3)) {
                for (n4 = 0; n4 < 2; ++n4) {
                    f3 = (float)n + random.nextFloat() * 0.1f;
                    f2 = (float)n2 + random.nextFloat();
                    f = (float)n3 + random.nextFloat();
                    level.addParticle("largesmoke", f3, f2, f, 0.0, 0.0, 0.0);
                }
            }
            if (Tile.fire.canBurn(level, n + 1, n2, n3)) {
                for (n4 = 0; n4 < 2; ++n4) {
                    f3 = (float)(n + 1) - random.nextFloat() * 0.1f;
                    f2 = (float)n2 + random.nextFloat();
                    f = (float)n3 + random.nextFloat();
                    level.addParticle("largesmoke", f3, f2, f, 0.0, 0.0, 0.0);
                }
            }
            if (Tile.fire.canBurn(level, n, n2, n3 - 1)) {
                for (n4 = 0; n4 < 2; ++n4) {
                    f3 = (float)n + random.nextFloat();
                    f2 = (float)n2 + random.nextFloat();
                    f = (float)n3 + random.nextFloat() * 0.1f;
                    level.addParticle("largesmoke", f3, f2, f, 0.0, 0.0, 0.0);
                }
            }
            if (Tile.fire.canBurn(level, n, n2, n3 + 1)) {
                for (n4 = 0; n4 < 2; ++n4) {
                    f3 = (float)n + random.nextFloat();
                    f2 = (float)n2 + random.nextFloat();
                    f = (float)(n3 + 1) - random.nextFloat() * 0.1f;
                    level.addParticle("largesmoke", f3, f2, f, 0.0, 0.0, 0.0);
                }
            }
            if (!Tile.fire.canBurn(level, n, n2 + 1, n3)) break block12;
            for (n4 = 0; n4 < 2; ++n4) {
                f3 = (float)n + random.nextFloat();
                f2 = (float)(n2 + 1) - random.nextFloat() * 0.1f;
                f = (float)n3 + random.nextFloat();
                level.addParticle("largesmoke", f3, f2, f, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean tryIgnite(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3);
        if (n4 == Tile.fire.id) {
            return true;
        }
        if (n4 == 0) {
            level.setTile(n, n2, n3, Tile.fire.id);
            return true;
        }
        return false;
    }
}

