/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.ArrayList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FenceTile
extends Tile {
    public FenceTile(int n, int n2) {
        super(n, n2, Material.wood);
    }

    @Override
    public void addAABBs(Level level, int n, int n2, int n3, AABB aABB, ArrayList<AABB> arrayList) {
        arrayList.add(AABB.newTemp(n, n2, n3, n + 1, (double)n2 + 1.5, n3 + 1));
    }

    @Override
    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (level.getTile(n, n2 - 1, n3) == this.id) {
            return false;
        }
        if (!level.getMaterial(n, n2 - 1, n3).isSolid()) {
            return false;
        }
        return super.mayPlace(level, n, n2, n3);
    }

    public boolean blocksLight() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public int getRenderShape() {
        return 11;
    }
}

