/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class FarmTile
extends Tile {
    protected FarmTile(int n) {
        super(n, Material.dirt);
        this.tex = 87;
        this.setTicking(true);
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setLightBlock(255);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return AABB.newTemp(n + 0, n2 + 0, n3 + 0, n + 1, n2 + 1, n3 + 1);
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getTexture(int n, int n2) {
        if (n == 1 && n2 > 0) {
            return this.tex - 1;
        }
        if (n == 1) {
            return this.tex;
        }
        return 2;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (random.nextInt(5) == 0) {
            if (this.isNearWater(level, n, n2, n3)) {
                level.setData(n, n2, n3, 7);
            } else {
                int n4 = level.getData(n, n2, n3);
                if (n4 > 0) {
                    level.setData(n, n2, n3, n4 - 1);
                } else if (!this.isUnderCrops(level, n, n2, n3)) {
                    level.setTile(n, n2, n3, Tile.dirt.id);
                }
            }
        }
    }

    public void stepOn(Level level, int n, int n2, int n3, Entity entity) {
        if (level.random.nextInt(4) == 0) {
            level.setTile(n, n2, n3, Tile.dirt.id);
        }
    }

    private boolean isUnderCrops(Level level, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n - n4; i <= n + n4; ++i) {
            for (int j = n3 - n4; j <= n3 + n4; ++j) {
                if (level.getTile(i, n2 + 1, j) != Tile.crops.id) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNearWater(Level level, int n, int n2, int n3) {
        for (int i = n - 4; i <= n + 4; ++i) {
            for (int j = n2; j <= n2 + 1; ++j) {
                for (int k = n3 - 4; k <= n3 + 4; ++k) {
                    if (level.getMaterial(i, j, k) != Material.water) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        super.neighborChanged(level, n, n2, n3, n4);
        Material material = level.getMaterial(n, n2 + 1, n3);
        if (material.isSolid()) {
            level.setTile(n, n2, n3, Tile.dirt.id);
        }
    }

    public boolean blocksLight() {
        return true;
    }

    public int getResource(int n, Random random) {
        return Tile.dirt.getResource(0, random);
    }
}

