/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DoorTile
extends Tile {
    protected DoorTile(int n, Material material) {
        super(n, material);
        this.tex = 97;
        if (material == Material.metal) {
            ++this.tex;
        }
        float f = 0.5f;
        float f2 = 1.0f;
        this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f2, 0.5f + f);
    }

    public int getTexture(int n, int n2) {
        if (n == 0 || n == 1) {
            return this.tex;
        }
        int n3 = this.getDir(n2);
        if ((n3 == 0 || n3 == 2) ^ n <= 3) {
            return this.tex;
        }
        int n4 = n3 / 2 + (n & 1 ^ n3);
        int n5 = this.tex - (n2 & 8) * 2;
        if (((n4 += (n2 & 4) / 4) & 1) != 0) {
            n5 = -n5;
        }
        return n5;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 7;
    }

    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        this.updateShape(level, n, n2, n3);
        return super.getTileAABB(level, n, n2, n3);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        this.updateShape(level, n, n2, n3);
        return super.getAABB(level, n, n2, n3);
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        this.setShape(this.getDir(levelSource.getData(n, n2, n3)));
    }

    public void setShape(int n) {
        float f = 0.1875f;
        this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        if (n == 0) {
            this.setShape(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (n == 1) {
            this.setShape(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (n == 2) {
            this.setShape(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (n == 3) {
            this.setShape(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    public void attack(Level level, int n, int n2, int n3, Player player) {
        this.use(level, n, n2, n3, player);
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        if (this.material == Material.metal) {
            return true;
        }
        int n4 = level.getData(n, n2, n3);
        if ((n4 & 8) != 0) {
            if (level.getTile(n, n2 - 1, n3) == this.id) {
                this.use(level, n, n2 - 1, n3, player);
            }
            return true;
        }
        if (level.getTile(n, n2 + 1, n3) == this.id) {
            level.setData(n, n2 + 1, n3, (n4 ^ 4) + 8);
        }
        level.setData(n, n2, n3, n4 ^ 4);
        level.setTilesDirty(n, n2 - 1, n3, n, n2, n3);
        if (Math.random() < 0.5) {
            level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.door_open", 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        } else {
            level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.door_close", 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        }
        return true;
    }

    public void setOpen(Level level, int n, int n2, int n3, boolean bl) {
        boolean bl2;
        int n4 = level.getData(n, n2, n3);
        if ((n4 & 8) != 0) {
            if (level.getTile(n, n2 - 1, n3) == this.id) {
                this.setOpen(level, n, n2 - 1, n3, bl);
            }
            return;
        }
        boolean bl3 = bl2 = (level.getData(n, n2, n3) & 4) > 0;
        if (bl2 == bl) {
            return;
        }
        if (level.getTile(n, n2 + 1, n3) == this.id) {
            level.setData(n, n2 + 1, n3, (n4 ^ 4) + 8);
        }
        level.setData(n, n2, n3, n4 ^ 4);
        level.setTilesDirty(n, n2 - 1, n3, n, n2, n3);
        if (Math.random() < 0.5) {
            level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.door_open", 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        } else {
            level.playSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.door_close", 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        int n5 = level.getData(n, n2, n3);
        if ((n5 & 8) != 0) {
            if (level.getTile(n, n2 - 1, n3) != this.id) {
                level.setTile(n, n2, n3, 0);
            }
            if (n4 > 0 && Tile.tiles[n4].isSignalSource()) {
                this.neighborChanged(level, n, n2 - 1, n3, n4);
            }
        } else {
            boolean bl = false;
            if (level.getTile(n, n2 + 1, n3) != this.id) {
                level.setTile(n, n2, n3, 0);
                bl = true;
            }
            if (!level.isSolidTile(n, n2 - 1, n3)) {
                level.setTile(n, n2, n3, 0);
                bl = true;
                if (level.getTile(n, n2 + 1, n3) == this.id) {
                    level.setTile(n, n2 + 1, n3, 0);
                }
            }
            if (bl) {
                this.spawnResources(level, n, n2, n3, n5);
            } else if (n4 > 0 && Tile.tiles[n4].isSignalSource()) {
                boolean bl2 = level.hasNeighborSignal(n, n2, n3) || level.hasNeighborSignal(n, n2 + 1, n3);
                this.setOpen(level, n, n2, n3, bl2);
            }
        }
    }

    public int getResource(int n, Random random) {
        if ((n & 8) != 0) {
            return 0;
        }
        if (this.material == Material.metal) {
            return Item.door_iron.id;
        }
        return Item.door_wood.id;
    }

    public HitResult clip(Level level, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.updateShape(level, n, n2, n3);
        return super.clip(level, n, n2, n3, vec3, vec32);
    }

    public int getDir(int n) {
        if ((n & 4) == 0) {
            return n - 1 & 3;
        }
        return n & 3;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (n2 >= 127) {
            return false;
        }
        return level.isSolidTile(n, n2 - 1, n3) && super.mayPlace(level, n, n2, n3) && super.mayPlace(level, n, n2 + 1, n3);
    }
}

