/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.EntityTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.DispenserTileEntity;
import net.minecraft.world.level.tile.entity.TileEntity;
import util.Mth;

public class DispenserTile
extends EntityTile {
    protected DispenserTile(int n) {
        super(n, Material.stone);
        this.tex = 45;
    }

    public int getTickDelay() {
        return 4;
    }

    public int getResource(int n, Random random) {
        return Tile.dispenser.id;
    }

    public void onPlace(Level level, int n, int n2, int n3) {
        super.onPlace(level, n, n2, n3);
        this.recalcLockDir(level, n, n2, n3);
    }

    private void recalcLockDir(Level level, int n, int n2, int n3) {
        int n4 = level.getTile(n, n2, n3 - 1);
        int n5 = level.getTile(n, n2, n3 + 1);
        int n6 = level.getTile(n - 1, n2, n3);
        int n7 = level.getTile(n + 1, n2, n3);
        int n8 = 3;
        if (Tile.solid[n4] && !Tile.solid[n5]) {
            n8 = 3;
        }
        if (Tile.solid[n5] && !Tile.solid[n4]) {
            n8 = 2;
        }
        if (Tile.solid[n6] && !Tile.solid[n7]) {
            n8 = 5;
        }
        if (Tile.solid[n7] && !Tile.solid[n6]) {
            n8 = 4;
        }
        level.setData(n, n2, n3, n8);
    }

    public int getTexture(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (n4 == 1) {
            return this.tex + 17;
        }
        if (n4 == 0) {
            return this.tex + 17;
        }
        int n5 = levelSource.getData(n, n2, n3);
        if (n4 != n5) {
            return this.tex;
        }
        return this.tex + 1;
    }

    public int getTexture(int n) {
        if (n == 1) {
            return this.tex + 17;
        }
        if (n == 0) {
            return this.tex + 17;
        }
        if (n == 3) {
            return this.tex + 1;
        }
        return this.tex;
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        if (level.isOnline) {
            return true;
        }
        DispenserTileEntity dispenserTileEntity = (DispenserTileEntity)level.getTileEntity(n, n2, n3);
        player.openTrap(dispenserTileEntity);
        return true;
    }

    private void fireArrow(Level level, int n, int n2, int n3, Random random) {
        int n4 = level.getData(n, n2, n3);
        float f = 0.0f;
        float f2 = 0.0f;
        if (n4 == 3) {
            f2 = 1.0f;
        } else if (n4 == 2) {
            f2 = -1.0f;
        } else {
            f = n4 == 5 ? 1.0f : -1.0f;
        }
        DispenserTileEntity dispenserTileEntity = (DispenserTileEntity)level.getTileEntity(n, n2, n3);
        ItemInstance itemInstance = dispenserTileEntity.removeRandomItem();
        double d = (double)n + (double)f * 0.5 + 0.5;
        double d2 = (double)n2 + 0.5;
        double d3 = (double)n3 + (double)f2 * 0.5 + 0.5;
        if (itemInstance == null) {
            level.playSound(n, n2, n3, "random.click", 1.0f, 1.2f);
        } else {
            double d4;
            Entity entity;
            if (itemInstance.id == Item.arrow.id) {
                entity = new Arrow(level, d, d2, d3);
                entity.shoot(f, 0.1f, f2, 1.1f, 6.0f);
                level.addEntity(entity);
                level.playSound(n, n2, n3, "random.bow", 1.0f, 1.2f);
            } else if (itemInstance.id == Item.egg.id) {
                entity = new ThrownEgg(level, d, d2, d3);
                ((ThrownEgg)entity).shoot(f, 0.1f, f2, 1.1f, 6.0f);
                level.addEntity(entity);
                level.playSound(n, n2, n3, "random.bow", 1.0f, 1.2f);
            } else if (itemInstance.id == Item.snowBall.id) {
                entity = new Snowball(level, d, d2, d3);
                ((Snowball)entity).shoot(f, 0.1f, f2, 1.1f, 6.0f);
                level.addEntity(entity);
                level.playSound(n, n2, n3, "random.bow", 1.0f, 1.2f);
            } else {
                entity = new ItemEntity(level, d, d2 - 0.3, d3, itemInstance);
                d4 = random.nextDouble() * 0.1 + 0.2;
                ((ItemEntity)entity).xd = (double)f * d4;
                ((ItemEntity)entity).yd = 0.2f;
                ((ItemEntity)entity).zd = (double)f2 * d4;
                ((ItemEntity)entity).xd += random.nextGaussian() * (double)0.0075f * 6.0;
                ((ItemEntity)entity).yd += random.nextGaussian() * (double)0.0075f * 6.0;
                ((ItemEntity)entity).zd += random.nextGaussian() * (double)0.0075f * 6.0;
                level.addEntity(entity);
                level.playSound(n, n2, n3, "random.click", 1.0f, 1.0f);
            }
            for (int i = 0; i < 10; ++i) {
                d4 = random.nextDouble() * 0.2 + 0.01;
                double d5 = d + (double)f * 0.01 + (random.nextDouble() - 0.5) * (double)f2 * 0.5;
                double d6 = d2 + (random.nextDouble() - 0.5) * 0.5;
                double d7 = d3 + (double)f2 * 0.01 + (random.nextDouble() - 0.5) * (double)f * 0.5;
                double d8 = (double)f * d4 + random.nextGaussian() * 0.01;
                double d9 = -0.03 + random.nextGaussian() * 0.01;
                double d10 = (double)f2 * d4 + random.nextGaussian() * 0.01;
                level.addParticle("smoke", d5, d6, d7, d8, d9, d10);
            }
        }
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Tile.tiles[n4].isSignalSource()) {
            boolean bl;
            boolean bl2 = bl = level.hasNeighborSignal(n, n2, n3) || level.hasNeighborSignal(n, n2 + 1, n3);
            if (bl) {
                level.addToTickNextTick(n, n2, n3, this.id);
            }
        }
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.hasNeighborSignal(n, n2, n3) || level.hasNeighborSignal(n, n2 + 1, n3)) {
            this.fireArrow(level, n, n2, n3, random);
        }
    }

    protected TileEntity newTileEntity() {
        return new DispenserTileEntity();
    }

    public void setPlacedBy(Level level, int n, int n2, int n3, Mob mob) {
        int n4 = Mth.floor((double)(mob.yRot * 4.0f / 360.0f) + 0.5) & 3;
        if (n4 == 0) {
            level.setData(n, n2, n3, 2);
        }
        if (n4 == 1) {
            level.setData(n, n2, n3, 5);
        }
        if (n4 == 2) {
            level.setData(n, n2, n3, 3);
        }
        if (n4 == 3) {
            level.setData(n, n2, n3, 4);
        }
    }
}

