/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.tile.Bush;
import net.minecraft.world.level.tile.Tile;

public class CropTile
extends Bush {
    protected CropTile(int n, int n2) {
        super(n, n2);
        this.tex = n2;
        this.setTicking(true);
        float f = 0.5f;
        this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    protected boolean mayPlaceOn(int n) {
        return n == Tile.farmland.id;
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        float f;
        int n4;
        super.tick(level, n, n2, n3, random);
        if (level.getRawBrightness(n, n2 + 1, n3) >= 9 && (n4 = level.getData(n, n2, n3)) < 7 && random.nextInt((int)(100.0f / (f = this.getGrowthSpeed(level, n, n2, n3)))) == 0) {
            level.setData(n, n2, n3, ++n4);
        }
    }

    public void growCropsToMax(Level level, int n, int n2, int n3) {
        level.setData(n, n2, n3, 7);
    }

    private float getGrowthSpeed(Level level, int n, int n2, int n3) {
        float f = 1.0f;
        int n4 = level.getTile(n, n2, n3 - 1);
        int n5 = level.getTile(n, n2, n3 + 1);
        int n6 = level.getTile(n - 1, n2, n3);
        int n7 = level.getTile(n + 1, n2, n3);
        int n8 = level.getTile(n - 1, n2, n3 - 1);
        int n9 = level.getTile(n + 1, n2, n3 - 1);
        int n10 = level.getTile(n + 1, n2, n3 + 1);
        int n11 = level.getTile(n - 1, n2, n3 + 1);
        boolean bl = n6 == this.id || n7 == this.id;
        boolean bl2 = n4 == this.id || n5 == this.id;
        boolean bl3 = n8 == this.id || n9 == this.id || n10 == this.id || n11 == this.id;
        for (int i = n - 1; i <= n + 1; ++i) {
            for (int j = n3 - 1; j <= n3 + 1; ++j) {
                int n12 = level.getTile(i, n2 - 1, j);
                float f2 = 0.0f;
                if (n12 == Tile.farmland.id) {
                    f2 = 1.0f;
                    if (level.getData(i, n2 - 1, j) > 0) {
                        f2 = 3.0f;
                    }
                }
                if (i != n || j != n3) {
                    f2 /= 4.0f;
                }
                f += f2;
            }
        }
        if (bl3 || bl && bl2) {
            f /= 2.0f;
        }
        return f;
    }

    public int getTexture(int n, int n2) {
        if (n2 < 0) {
            n2 = 7;
        }
        return this.tex + n2;
    }

    public int getRenderShape() {
        return 6;
    }

    public void destroy(Level level, int n, int n2, int n3, int n4) {
        super.destroy(level, n, n2, n3, n4);
        if (!level.isOnline) {
            for (int i = 0; i < 3; ++i) {
                if (level.random.nextInt(15) > n4) continue;
                float f = 0.7f;
                float f2 = level.random.nextFloat() * f + (1.0f - f) * 0.5f;
                float f3 = level.random.nextFloat() * f + (1.0f - f) * 0.5f;
                float f4 = level.random.nextFloat() * f + (1.0f - f) * 0.5f;
                ItemEntity itemEntity = new ItemEntity(level, (float)n + f2, (float)n2 + f3, (float)n3 + f4, new ItemInstance(Item.seeds));
                itemEntity.throwTime = 10;
                level.addEntity(itemEntity);
            }
        }
    }

    public int getResource(int n, Random random) {
        if (n == 7) {
            return Item.wheat.id;
        }
        return -1;
    }

    public int getResourceCount(Random random) {
        return 1;
    }
}

