/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.EntityTile;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.level.tile.entity.ChestTileEntity;
import net.minecraft.world.level.tile.entity.TileEntity;

public class ChestTile
extends EntityTile {
    private Random random = new Random();

    protected ChestTile(int n) {
        super(n, Material.wood);
        this.tex = 26;
    }

    public int getTexture(LevelSource levelSource, int n, int n2, int n3, int n4) {
        if (n4 == 1) {
            return this.tex - 1;
        }
        if (n4 == 0) {
            return this.tex - 1;
        }
        int n5 = levelSource.getTile(n, n2, n3 - 1);
        int n6 = levelSource.getTile(n, n2, n3 + 1);
        int n7 = levelSource.getTile(n - 1, n2, n3);
        int n8 = levelSource.getTile(n + 1, n2, n3);
        if (n5 == this.id || n6 == this.id) {
            if (n4 == 2 || n4 == 3) {
                return this.tex;
            }
            int n9 = 0;
            if (n5 == this.id) {
                n9 = -1;
            }
            int n10 = levelSource.getTile(n - 1, n2, n5 == this.id ? n3 - 1 : n3 + 1);
            int n11 = levelSource.getTile(n + 1, n2, n5 == this.id ? n3 - 1 : n3 + 1);
            if (n4 == 4) {
                n9 = -1 - n9;
            }
            int n12 = 5;
            if ((Tile.solid[n7] || Tile.solid[n10]) && !Tile.solid[n8] && !Tile.solid[n11]) {
                n12 = 5;
            }
            if ((Tile.solid[n8] || Tile.solid[n11]) && !Tile.solid[n7] && !Tile.solid[n10]) {
                n12 = 4;
            }
            return (n4 == n12 ? this.tex + 16 : this.tex + 32) + n9;
        }
        if (n7 == this.id || n8 == this.id) {
            if (n4 == 4 || n4 == 5) {
                return this.tex;
            }
            int n13 = 0;
            if (n7 == this.id) {
                n13 = -1;
            }
            int n14 = levelSource.getTile(n7 == this.id ? n - 1 : n + 1, n2, n3 - 1);
            int n15 = levelSource.getTile(n7 == this.id ? n - 1 : n + 1, n2, n3 + 1);
            if (n4 == 3) {
                n13 = -1 - n13;
            }
            int n16 = 3;
            if ((Tile.solid[n5] || Tile.solid[n14]) && !Tile.solid[n6] && !Tile.solid[n15]) {
                n16 = 3;
            }
            if ((Tile.solid[n6] || Tile.solid[n15]) && !Tile.solid[n5] && !Tile.solid[n14]) {
                n16 = 2;
            }
            return (n4 == n16 ? this.tex + 16 : this.tex + 32) + n13;
        }
        int n17 = 3;
        if (Tile.solid[n5] && !Tile.solid[n6]) {
            n17 = 3;
        }
        if (Tile.solid[n6] && !Tile.solid[n5]) {
            n17 = 2;
        }
        if (Tile.solid[n7] && !Tile.solid[n8]) {
            n17 = 5;
        }
        if (Tile.solid[n8] && !Tile.solid[n7]) {
            n17 = 4;
        }
        return n4 == n17 ? this.tex + 1 : this.tex;
    }

    public int getTexture(int n) {
        if (n == 1) {
            return this.tex - 1;
        }
        if (n == 0) {
            return this.tex - 1;
        }
        if (n == 3) {
            return this.tex + 1;
        }
        return this.tex;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        int n4 = 0;
        if (level.getTile(n - 1, n2, n3) == this.id) {
            ++n4;
        }
        if (level.getTile(n + 1, n2, n3) == this.id) {
            ++n4;
        }
        if (level.getTile(n, n2, n3 - 1) == this.id) {
            ++n4;
        }
        if (level.getTile(n, n2, n3 + 1) == this.id) {
            ++n4;
        }
        if (n4 > 1) {
            return false;
        }
        if (this.isFullChest(level, n - 1, n2, n3)) {
            return false;
        }
        if (this.isFullChest(level, n + 1, n2, n3)) {
            return false;
        }
        if (this.isFullChest(level, n, n2, n3 - 1)) {
            return false;
        }
        return !this.isFullChest(level, n, n2, n3 + 1);
    }

    private boolean isFullChest(Level level, int n, int n2, int n3) {
        if (level.getTile(n, n2, n3) != this.id) {
            return false;
        }
        if (level.getTile(n - 1, n2, n3) == this.id) {
            return true;
        }
        if (level.getTile(n + 1, n2, n3) == this.id) {
            return true;
        }
        if (level.getTile(n, n2, n3 - 1) == this.id) {
            return true;
        }
        return level.getTile(n, n2, n3 + 1) == this.id;
    }

    public void onRemove(Level level, int n, int n2, int n3) {
        ChestTileEntity chestTileEntity = (ChestTileEntity)level.getTileEntity(n, n2, n3);
        for (int i = 0; i < chestTileEntity.getContainerSize(); ++i) {
            ItemInstance itemInstance = chestTileEntity.getItem(i);
            if (itemInstance == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            float f3 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemInstance.count > 0) {
                int n4 = this.random.nextInt(21) + 10;
                if (n4 > itemInstance.count) {
                    n4 = itemInstance.count;
                }
                itemInstance.count -= n4;
                ItemEntity itemEntity = new ItemEntity(level, (float)n + f, (float)n2 + f2, (float)n3 + f3, new ItemInstance(itemInstance.id, n4, itemInstance.getAuxValue()));
                float f4 = 0.05f;
                itemEntity.xd = (float)this.random.nextGaussian() * f4;
                itemEntity.yd = (float)this.random.nextGaussian() * f4 + 0.2f;
                itemEntity.zd = (float)this.random.nextGaussian() * f4;
                level.addEntity(itemEntity);
            }
        }
        super.onRemove(level, n, n2, n3);
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        Container container = (ChestTileEntity)level.getTileEntity(n, n2, n3);
        if (level.isSolidTile(n, n2 + 1, n3)) {
            return true;
        }
        if (level.getTile(n - 1, n2, n3) == this.id && level.isSolidTile(n - 1, n2 + 1, n3)) {
            return true;
        }
        if (level.getTile(n + 1, n2, n3) == this.id && level.isSolidTile(n + 1, n2 + 1, n3)) {
            return true;
        }
        if (level.getTile(n, n2, n3 - 1) == this.id && level.isSolidTile(n, n2 + 1, n3 - 1)) {
            return true;
        }
        if (level.getTile(n, n2, n3 + 1) == this.id && level.isSolidTile(n, n2 + 1, n3 + 1)) {
            return true;
        }
        if (level.getTile(n - 1, n2, n3) == this.id) {
            container = new CompoundContainer("Large chest", (ChestTileEntity)level.getTileEntity(n - 1, n2, n3), container);
        }
        if (level.getTile(n + 1, n2, n3) == this.id) {
            container = new CompoundContainer("Large chest", container, (ChestTileEntity)level.getTileEntity(n + 1, n2, n3));
        }
        if (level.getTile(n, n2, n3 - 1) == this.id) {
            container = new CompoundContainer("Large chest", (ChestTileEntity)level.getTileEntity(n, n2, n3 - 1), container);
        }
        if (level.getTile(n, n2, n3 + 1) == this.id) {
            container = new CompoundContainer("Large chest", container, (ChestTileEntity)level.getTileEntity(n, n2, n3 + 1));
        }
        if (level.isOnline) {
            return true;
        }
        player.openContainer(container);
        return true;
    }

    protected TileEntity newTileEntity() {
        return new ChestTileEntity();
    }
}

