/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class CakeTile
extends Tile {
    protected CakeTile(int n, int n2) {
        super(n, n2, Material.cake);
        this.setTicking(true);
    }

    public void updateShape(LevelSource levelSource, int n, int n2, int n3) {
        int n4 = levelSource.getData(n, n2, n3);
        float f = 0.0625f;
        float f2 = (float)(1 + n4 * 2) / 16.0f;
        float f3 = 0.5f;
        this.setShape(f2, 0.0f, f, 1.0f - f, f3, 1.0f - f);
    }

    public void updateDefaultShape() {
        float f = 0.0625f;
        float f2 = 0.5f;
        this.setShape(f, 0.0f, f, 1.0f - f, f2, 1.0f - f);
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        float f = 0.0625f;
        float f2 = (float)(1 + n4 * 2) / 16.0f;
        float f3 = 0.5f;
        return AABB.newTemp((float)n + f2, n2, (float)n3 + f, (float)(n + 1) - f, (float)n2 + f3 - f, (float)(n3 + 1) - f);
    }

    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        int n4 = level.getData(n, n2, n3);
        float f = 0.0625f;
        float f2 = (float)(1 + n4 * 2) / 16.0f;
        float f3 = 0.5f;
        return AABB.newTemp((float)n + f2, n2, (float)n3 + f, (float)(n + 1) - f, (float)n2 + f3, (float)(n3 + 1) - f);
    }

    public int getTexture(int n, int n2) {
        if (n == 1) {
            return this.tex;
        }
        if (n == 0) {
            return this.tex + 3;
        }
        if (n2 > 0 && n == 4) {
            return this.tex + 2;
        }
        return this.tex + 1;
    }

    public int getTexture(int n) {
        if (n == 1) {
            return this.tex;
        }
        if (n == 0) {
            return this.tex + 3;
        }
        return this.tex + 1;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean use(Level level, int n, int n2, int n3, Player player) {
        this.eat(level, n, n2, n3, player);
        return true;
    }

    public void attack(Level level, int n, int n2, int n3, Player player) {
        this.eat(level, n, n2, n3, player);
    }

    private void eat(Level level, int n, int n2, int n3, Player player) {
        if (player.health < 20) {
            player.heal(3);
            int n4 = level.getData(n, n2, n3) + 1;
            if (n4 >= 6) {
                level.setTile(n, n2, n3, 0);
            } else {
                level.setData(n, n2, n3, n4);
                level.setTileDirty(n, n2, n3);
            }
        }
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (!super.mayPlace(level, n, n2, n3)) {
            return false;
        }
        return this.canSurvive(level, n, n2, n3);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (!this.canSurvive(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
    }

    public boolean canSurvive(Level level, int n, int n2, int n3) {
        return level.getMaterial(n, n2 - 1, n3).isSolid();
    }

    public int getResourceCount(Random random) {
        return 0;
    }

    public int getResource(int n, Random random) {
        return 0;
    }
}

