/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class CactusTile
extends Tile {
    protected CactusTile(int n, int n2) {
        super(n, n2, Material.cactus);
        this.setTicking(true);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        if (level.isEmptyTile(n, n2 + 1, n3)) {
            int n4 = 1;
            while (level.getTile(n, n2 - n4, n3) == this.id) {
                ++n4;
            }
            if (n4 < 3) {
                int n5 = level.getData(n, n2, n3);
                if (n5 == 15) {
                    level.setTile(n, n2 + 1, n3, this.id);
                    level.setData(n, n2, n3, 0);
                } else {
                    level.setData(n, n2, n3, n5 + 1);
                }
            }
        }
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        float f = 0.0625f;
        return AABB.newTemp((float)n + f, n2, (float)n3 + f, (float)(n + 1) - f, (float)(n2 + 1) - f, (float)(n3 + 1) - f);
    }

    public AABB getTileAABB(Level level, int n, int n2, int n3) {
        float f = 0.0625f;
        return AABB.newTemp((float)n + f, n2, (float)n3 + f, (float)(n + 1) - f, n2 + 1, (float)(n3 + 1) - f);
    }

    public int getTexture(int n) {
        if (n == 1) {
            return this.tex - 1;
        }
        if (n == 0) {
            return this.tex + 1;
        }
        return this.tex;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public int getRenderShape() {
        return 13;
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        if (!super.mayPlace(level, n, n2, n3)) {
            return false;
        }
        return this.canSurvive(level, n, n2, n3);
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        if (!this.canSurvive(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
    }

    public boolean canSurvive(Level level, int n, int n2, int n3) {
        if (level.getMaterial(n - 1, n2, n3).isSolid()) {
            return false;
        }
        if (level.getMaterial(n + 1, n2, n3).isSolid()) {
            return false;
        }
        if (level.getMaterial(n, n2, n3 - 1).isSolid()) {
            return false;
        }
        if (level.getMaterial(n, n2, n3 + 1).isSolid()) {
            return false;
        }
        int n4 = level.getTile(n, n2 - 1, n3);
        return n4 == Tile.cactus.id || n4 == Tile.sand.id;
    }

    public void entityInside(Level level, int n, int n2, int n3, Entity entity) {
        entity.hurt(null, 1);
    }
}

