/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.tile;

import java.util.Random;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.tile.Tile;
import net.minecraft.world.phys.AABB;

public class Bush
extends Tile {
    protected Bush(int n, int n2) {
        super(n, Material.plant);
        this.tex = n2;
        this.setTicking(true);
        float f = 0.2f;
        this.setShape(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
    }

    public boolean mayPlace(Level level, int n, int n2, int n3) {
        return this.mayPlaceOn(level.getTile(n, n2 - 1, n3));
    }

    protected boolean mayPlaceOn(int n) {
        return n == Tile.grass.id || n == Tile.dirt.id || n == Tile.farmland.id;
    }

    public void neighborChanged(Level level, int n, int n2, int n3, int n4) {
        super.neighborChanged(level, n, n2, n3, n4);
        this.checkAlive(level, n, n2, n3);
    }

    public void tick(Level level, int n, int n2, int n3, Random random) {
        this.checkAlive(level, n, n2, n3);
    }

    protected final void checkAlive(Level level, int n, int n2, int n3) {
        if (!this.canSurvive(level, n, n2, n3)) {
            this.spawnResources(level, n, n2, n3, level.getData(n, n2, n3));
            level.setTile(n, n2, n3, 0);
        }
    }

    public boolean canSurvive(Level level, int n, int n2, int n3) {
        return (level.getRawBrightness(n, n2, n3) >= 8 || level.canSeeSky(n, n2, n3)) && this.mayPlaceOn(level.getTile(n, n2 - 1, n3));
    }

    public AABB getAABB(Level level, int n, int n2, int n3) {
        return null;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public int getRenderShape() {
        return 1;
    }
}

