/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelSource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import util.IntHashMap;
import util.Mth;

public class PathFinder {
    private LevelSource level;
    private BinaryHeap openSet = new BinaryHeap();
    private IntHashMap<Node> nodes = new IntHashMap();
    private Node[] neighbors = new Node[32];

    public PathFinder(LevelSource levelSource) {
        this.level = levelSource;
    }

    public Path findPath(Entity entity, Entity entity2, float f) {
        return this.findPath(entity, entity2.x, entity2.bb.y0, entity2.z, f);
    }

    public Path findPath(Entity entity, int n, int n2, int n3, float f) {
        return this.findPath(entity, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, f);
    }

    private Path findPath(Entity entity, double d, double d2, double d3, float f) {
        this.openSet.clear();
        this.nodes.clear();
        Node node = this.getNode(Mth.floor(entity.bb.x0), Mth.floor(entity.bb.y0), Mth.floor(entity.bb.z0));
        Node node2 = this.getNode(Mth.floor(d - (double)(entity.bbWidth / 2.0f)), Mth.floor(d2), Mth.floor(d3 - (double)(entity.bbWidth / 2.0f)));
        Node node3 = new Node(Mth.floor(entity.bbWidth + 1.0f), Mth.floor(entity.bbHeight + 1.0f), Mth.floor(entity.bbWidth + 1.0f));
        Path path = this.findPath(entity, node, node2, node3, f);
        return path;
    }

    private Path findPath(Entity entity, Node node, Node node2, Node node3, float f) {
        node.g = 0.0f;
        node.f = node.h = node.distanceTo(node2);
        this.openSet.clear();
        this.openSet.insert(node);
        Node node4 = node;
        while (!this.openSet.isEmpty()) {
            Node node5 = this.openSet.pop();
            if (node5.hash == node2.hash) {
                return this.reconstruct_path(node, node2);
            }
            if (node5.distanceTo(node2) < node4.distanceTo(node2)) {
                node4 = node5;
            }
            node5.closed = true;
            int n = this.getNeighbors(entity, node5, node3, node2, f);
            for (int i = 0; i < n; ++i) {
                Node node6 = this.neighbors[i];
                float f2 = node5.g + node5.distanceTo(node6);
                if (node6.inOpenSet() && !(f2 < node6.g)) continue;
                node6.cameFrom = node5;
                node6.g = f2;
                node6.h = node6.distanceTo(node2);
                if (node6.inOpenSet()) {
                    this.openSet.changeCost(node6, node6.g + node6.h);
                    continue;
                }
                node6.f = node6.g + node6.h;
                this.openSet.insert(node6);
            }
        }
        if (node4 == node) {
            return null;
        }
        return this.reconstruct_path(node, node4);
    }

    private int getNeighbors(Entity entity, Node node, Node node2, Node node3, float f) {
        int n = 0;
        int n2 = 0;
        if (this.isFree(entity, node.x, node.y + 1, node.z, node2) > 0) {
            n2 = 1;
        }
        Node node4 = this.getNode(entity, node.x, node.y, node.z + 1, node2, n2);
        Node node5 = this.getNode(entity, node.x - 1, node.y, node.z, node2, n2);
        Node node6 = this.getNode(entity, node.x + 1, node.y, node.z, node2, n2);
        Node node7 = this.getNode(entity, node.x, node.y, node.z - 1, node2, n2);
        if (node4 != null && !node4.closed && node4.distanceTo(node3) < f) {
            this.neighbors[n++] = node4;
        }
        if (node5 != null && !node5.closed && node5.distanceTo(node3) < f) {
            this.neighbors[n++] = node5;
        }
        if (node6 != null && !node6.closed && node6.distanceTo(node3) < f) {
            this.neighbors[n++] = node6;
        }
        if (node7 != null && !node7.closed && node7.distanceTo(node3) < f) {
            this.neighbors[n++] = node7;
        }
        return n;
    }

    private Node getNode(Entity entity, int n, int n2, int n3, Node node, int n4) {
        Node node2 = null;
        if (this.isFree(entity, n, n2, n3, node) > 0) {
            node2 = this.getNode(n, n2, n3);
        }
        if (node2 == null && this.isFree(entity, n, n2 + n4, n3, node) > 0) {
            node2 = this.getNode(n, n2 + n4, n3);
            n2 += n4;
        }
        if (node2 != null) {
            int n5 = 0;
            int n6 = 0;
            while (n2 > 0 && (n6 = this.isFree(entity, n, n2 - 1, n3, node)) > 0) {
                if (n6 < 0) {
                    return null;
                }
                if (++n5 >= 4) {
                    return null;
                }
                --n2;
            }
            if (n2 > 0) {
                node2 = this.getNode(n, n2, n3);
            }
        }
        return node2;
    }

    private final Node getNode(int n, int n2, int n3) {
        int n4 = n | n2 << 10 | n3 << 20;
        Node node = this.nodes.get(n4);
        if (node == null) {
            node = new Node(n, n2, n3);
            this.nodes.put(n4, node);
        }
        return node;
    }

    private int isFree(Entity entity, int n, int n2, int n3, Node node) {
        for (int i = n; i < n + node.x; ++i) {
            for (int j = n2; j < n2 + node.y; ++j) {
                for (int k = n3; k < n3 + node.z; ++k) {
                    Material material = this.level.getMaterial(n, n2, n3);
                    if (material.blocksMotion()) {
                        return 0;
                    }
                    if (material != Material.water && material != Material.lava) continue;
                    return -1;
                }
            }
        }
        return 1;
    }

    private Path reconstruct_path(Node node, Node node2) {
        int n = 1;
        Node node3 = node2;
        while (node3.cameFrom != null) {
            ++n;
            node3 = node3.cameFrom;
        }
        Node[] nodeArray = new Node[n];
        node3 = node2;
        nodeArray[--n] = node3;
        while (node3.cameFrom != null) {
            node3 = node3.cameFrom;
            nodeArray[--n] = node3;
        }
        return new Path(nodeArray);
    }
}

